/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.annotations.VisibleForTesting;

public class ProgressMonitor
implements IProgressMonitor,
Runnable {
    private final Logger logger;
    private final long period;
    private final Thread thread;
    private final BooleanSupplier isCanceled;
    private boolean success = false;
    private int totalWork = 0;
    private boolean unknownTotalWork = false;
    private int processedWork = 0;

    @VisibleForTesting
    ProgressMonitor(BooleanSupplier isCanceled, Logger logger, long period) {
        this.isCanceled = isCanceled;
        this.logger = logger;
        this.period = period;
        this.thread = new Thread(this);
        this.thread.setName("Report about progress of Java AST analyzer");
        this.thread.setDaemon(true);
    }

    public ProgressMonitor(BooleanSupplier isCanceled) {
        this(isCanceled, Loggers.get(ProgressMonitor.class), TimeUnit.SECONDS.toMillis(10L));
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(this.period);
                if (this.unknownTotalWork) {
                    this.log(String.format("%d/UNKNOWN unit(s) analyzed", this.processedWork));
                    continue;
                }
                double percentage = (double)this.processedWork / (double)this.totalWork;
                this.log(String.format("%d%% analyzed", (int)(percentage * 100.0)));
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
                break;
            }
        }
    }

    @Override
    public void beginTask(String name, int totalWork) {
        if (totalWork <= 0) {
            this.unknownTotalWork = true;
        }
        this.totalWork = totalWork;
        this.log("Starting batch processing.");
        this.thread.start();
    }

    @Override
    public void done() {
        if (this.success) {
            this.log("100% analyzed");
            this.log("Batch processing: Done!");
        }
        this.thread.interrupt();
        this.join();
    }

    @Override
    public boolean isCanceled() {
        if (this.isCanceled.getAsBoolean()) {
            this.log("Batch processing: Cancelled!");
            return true;
        }
        return false;
    }

    @Override
    public void setCanceled(boolean value) {
    }

    private void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void worked(int work) {
        this.processedWork += work;
        if (this.processedWork == this.totalWork) {
            this.success = true;
        }
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public void setTaskName(String name) {
    }

    @Override
    public void subTask(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String message) {
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.info(message);
            this.logger.notifyAll();
        }
    }
}

