/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class AbstractDeprecatedChecker
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(PublicApiChecker.apiKinds());
    }

    public static boolean hasJavadocDeprecatedTag(Tree tree) {
        return AbstractDeprecatedChecker.hasJavadocDeprecatedTag(PublicApiChecker.getApiJavadoc(tree));
    }

    public static boolean hasJavadocDeprecatedTag(@Nullable String comment) {
        return comment != null && comment.startsWith("/**") && comment.contains("@deprecated");
    }

    public static boolean hasDeprecatedAnnotation(Tree tree) {
        return AbstractDeprecatedChecker.deprecatedAnnotation(tree) != null;
    }

    @CheckForNull
    public static AnnotationTree deprecatedAnnotation(Tree tree) {
        if (tree.is(CLASS_KINDS)) {
            return AbstractDeprecatedChecker.deprecatedAnnotation((ClassTree)tree);
        }
        if (tree.is(METHOD_KINDS)) {
            return AbstractDeprecatedChecker.deprecatedAnnotation((MethodTree)tree);
        }
        if (tree.is(Tree.Kind.VARIABLE)) {
            return AbstractDeprecatedChecker.deprecatedAnnotation((VariableTree)tree);
        }
        return null;
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(ClassTree classTree) {
        return AbstractDeprecatedChecker.deprecatedAnnotation(classTree.modifiers().annotations());
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(VariableTree variableTree) {
        return AbstractDeprecatedChecker.deprecatedAnnotation(variableTree.modifiers().annotations());
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(MethodTree methodTree) {
        return AbstractDeprecatedChecker.deprecatedAnnotation(methodTree.modifiers().annotations());
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(Iterable<AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            if (!AbstractDeprecatedChecker.isDeprecated(annotationTree)) continue;
            return annotationTree;
        }
        return null;
    }

    protected static Tree getReportTree(Tree tree) {
        Tree reportTree = tree;
        if (reportTree.is(PublicApiChecker.classKinds())) {
            reportTree = ExpressionsHelper.reportOnClassTree((ClassTree)reportTree);
        } else if (reportTree.is(PublicApiChecker.methodKinds())) {
            reportTree = ((MethodTree)reportTree).simpleName();
        } else if (reportTree.is(Tree.Kind.VARIABLE)) {
            reportTree = ((VariableTree)reportTree).simpleName();
        }
        return reportTree;
    }

    public static boolean isDeprecated(AnnotationTree tree) {
        return tree.annotationType().is(Tree.Kind.IDENTIFIER) && "Deprecated".equals(((IdentifierTree)tree.annotationType()).name());
    }
}

