/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1188")
public class AnonymousClassesTooBigCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="Max", description="Maximum allowed lines in an anonymous class", defaultValue="20")
    public int max = 20;
    private JavaFileScannerContext context;
    private boolean isEnumConstantBody;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.isEnumConstantBody = false;
        this.scan(context.getTree());
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        int lines;
        if (tree.classBody() != null && !this.isEnumConstantBody && (lines = AnonymousClassesTooBigCheck.getNumberOfLines(tree.classBody())) > this.max) {
            this.context.reportIssue(this, tree.newKeyword(), tree.identifier(), "Reduce this anonymous class number of lines from " + lines + " to at most " + this.max + ", or make it a named class.");
        }
        this.isEnumConstantBody = false;
        super.visitNewClass(tree);
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.isEnumConstantBody = true;
        super.visitEnumConstant(tree);
    }

    private static int getNumberOfLines(Tree tree) {
        return new LinesOfCodeVisitor().linesOfCode(tree);
    }
}

