/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4274")
public class AssertsOnParametersOfPublicMethodCheck
extends IssuableSubscriptionVisitor {
    private final Set<AssertStatementTree> assertReported = new HashSet<AssertStatementTree>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.assertReported.clear();
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (!methodTree.symbol().isPublic()) {
            return;
        }
        methodTree.parameters().stream().map(VariableTree::symbol).map(Symbol::usages).flatMap(Collection::stream).forEach(parameter -> this.checkUsage((IdentifierTree)parameter, methodTree));
    }

    private void checkUsage(IdentifierTree parameterUsage, MethodTree methodTree) {
        Tree parameterParent = parameterUsage.parent();
        while (!parameterParent.equals(methodTree) && !this.assertReported.contains(parameterParent)) {
            if (parameterParent.is(Tree.Kind.ASSERT_STATEMENT)) {
                this.assertReported.add((AssertStatementTree)parameterParent);
                this.reportIssue(parameterParent, "Replace this assert with a proper check.");
                return;
            }
            parameterParent = parameterParent.parent();
        }
    }
}

