/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6204")
public class CollectorsToListCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String MESSAGE = "Replace this usage of 'Stream.collect(Collectors.%s())' with 'Stream.toList()'";
    private static final MethodMatchers COLLECT = MethodMatchers.create().ofSubTypes("java.util.stream.Stream").names("collect").addParametersMatcher("java.util.stream.Collector").build();
    private static final MethodMatchers COLLECTORS_TO_LIST = MethodMatchers.create().ofSubTypes("java.util.stream.Collectors").names("toList").addWithoutParametersMatcher().build();
    private static final MethodMatchers COLLECTORS_TO_UNMODIFIABLE_LIST = MethodMatchers.create().ofSubTypes("java.util.stream.Collectors").names("toUnmodifiableList").addWithoutParametersMatcher().build();
    private static final MethodMatchers LIST_MODIFICATION_METHODS = MethodMatchers.create().ofSubTypes("java.util.List").names("add", "addAll", "remove", "removeAll", "retainAll", "replaceAll", "set", "sort", "clear").withAnyParameters().build();

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava16Compatible();
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return COLLECT;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        boolean mutable;
        if (!((ExpressionTree)mit.arguments().get(0)).is(Tree.Kind.METHOD_INVOCATION)) {
            return;
        }
        MethodInvocationTree collector = (MethodInvocationTree)mit.arguments().get(0);
        if (COLLECTORS_TO_LIST.matches(collector)) {
            mutable = true;
        } else if (COLLECTORS_TO_UNMODIFIABLE_LIST.matches(collector)) {
            mutable = false;
        } else {
            return;
        }
        Symbol assignedVariable = CollectorsToListCheck.findAssignedVariable(mit.parent());
        if (!mutable || assignedVariable == null || assignedVariable.usages().stream().noneMatch(CollectorsToListCheck::isListBeingModified)) {
            this.reportIssue(collector, mutable);
        }
    }

    private void reportIssue(MethodInvocationTree collector, boolean mutable) {
        String message = String.format(MESSAGE, mutable ? "toList" : "toUnmodifiableList");
        this.reportIssue((Tree)collector, message);
    }

    private static boolean isListBeingModified(Tree list) {
        while (list.parent().is(Tree.Kind.ARRAY_ACCESS_EXPRESSION, Tree.Kind.MEMBER_SELECT)) {
            Tree possibleMethodInvocation = list.parent().parent();
            if (possibleMethodInvocation.is(Tree.Kind.METHOD_INVOCATION)) {
                MethodInvocationTree mit = (MethodInvocationTree)possibleMethodInvocation;
                ExpressionTree receiver = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
                return receiver == list && LIST_MODIFICATION_METHODS.matches(mit);
            }
            list = list.parent();
        }
        return false;
    }

    @CheckForNull
    private static Symbol findAssignedVariable(Tree tree) {
        switch (tree.kind()) {
            case ASSIGNMENT: {
                return CollectorsToListCheck.findAssignedVariable(((AssignmentExpressionTree)tree).variable());
            }
            case VARIABLE: {
                return ((VariableTree)tree).symbol();
            }
            case IDENTIFIER: {
                return ((IdentifierTree)tree).symbol();
            }
            case MEMBER_SELECT: {
                return ((MemberSelectExpressionTree)tree).identifier().symbol();
            }
            case ARRAY_ACCESS_EXPRESSION: {
                return CollectorsToListCheck.findAssignedVariable(((ArrayAccessExpressionTree)tree).expression());
            }
        }
        return null;
    }
}

