/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1213")
public class IncorrectOrderOfMembersCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String[] NAMES = new String[]{"static variable", "variable", "constructor", "method"};
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        int prev = 0;
        for (int i = 0; i < tree.members().size(); ++i) {
            IdentifierTree identifier;
            int priority;
            Tree member = tree.members().get(i);
            if (member.is(Tree.Kind.VARIABLE)) {
                VariableTree variable = (VariableTree)member;
                priority = variable.symbol().isStatic() ? 0 : 1;
                identifier = variable.simpleName();
            } else if (member.is(Tree.Kind.CONSTRUCTOR)) {
                priority = 2;
                identifier = ((MethodTree)member).simpleName();
            } else {
                if (!member.is(Tree.Kind.METHOD)) continue;
                priority = 3;
                identifier = ((MethodTree)member).simpleName();
            }
            if (priority < prev) {
                this.context.reportIssue(this, identifier, "Move this " + NAMES[priority] + " to comply with Java Code Conventions.");
                continue;
            }
            prev = priority;
        }
        super.visitClass(tree);
    }
}

