/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2325")
public class StaticMethodCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_IO_SERIALIZABLE = "java.io.Serializable";
    private static final MethodMatchers EXCLUDED_SERIALIZABLE_METHODS = MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.io.Serializable").names("readObject").addParametersMatcher(params -> params.size() == 1 && ((Type)params.get(0)).isSubtypeOf("java.io.ObjectInputStream")).build(), MethodMatchers.create().ofSubTypes("java.io.Serializable").names("writeObject").addParametersMatcher(params -> params.size() == 1 && ((Type)params.get(0)).isSubtypeOf("java.io.ObjectOutputStream")).build(), MethodMatchers.create().ofSubTypes("java.io.Serializable").names("readObjectNoData", "writeReplace", "readResolve").addWithoutParametersMatcher().build());
    private JavaFileScannerContext context;
    private Deque<MethodReference> methodReferences = new LinkedList<MethodReference>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan(context.getTree());
        }
    }

    @Override
    public void visitMethod(MethodTree tree) {
        if (StaticMethodCheck.isExcluded(tree)) {
            return;
        }
        Symbol.MethodSymbol symbol = tree.symbol();
        this.methodReferences.push(new MethodReference(symbol));
        this.scan(tree.parameters());
        this.scan(tree.block());
        MethodReference reference = this.methodReferences.pop();
        ClassTree classTree = (ClassTree)tree.parent();
        if (!Boolean.FALSE.equals(tree.isOverriding()) || classTree.is(Tree.Kind.ENUM)) {
            return;
        }
        if ((symbol.isPrivate() || symbol.isFinal() || classTree.symbol().isFinal()) && !symbol.isStatic() && !reference.hasNonStaticReference()) {
            this.context.reportIssue(this, tree.simpleName(), "Make \"" + symbol.name() + "\" a \"static\" method.");
        }
    }

    private static boolean isExcluded(MethodTree tree) {
        return tree.is(Tree.Kind.CONSTRUCTOR) || EXCLUDED_SERIALIZABLE_METHODS.matches(tree) || StaticMethodCheck.hasEmptyBody(tree);
    }

    private static boolean hasEmptyBody(MethodTree tree) {
        return tree.block() != null && tree.block().body().isEmpty();
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        MemberSelectExpressionTree parent;
        super.visitIdentifier(tree);
        if ("class".equals(tree.name()) || this.methodReferences.isEmpty()) {
            return;
        }
        if (StaticMethodCheck.parentIs(tree, Tree.Kind.MEMBER_SELECT) && tree.equals((parent = (MemberSelectExpressionTree)tree.parent()).identifier()) && !StaticMethodCheck.parentIs(parent, Tree.Kind.NEW_CLASS) && !StaticMethodCheck.refToEnclosingClass(tree)) {
            return;
        }
        this.visitTerminalIdentifier(tree);
    }

    private static boolean refToEnclosingClass(IdentifierTree tree) {
        String identifier = tree.name();
        return "this".equals(identifier) || "super".equals(identifier);
    }

    private void visitTerminalIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        MethodReference currentMethod = this.methodReferences.peek();
        if (symbol.isUnknown()) {
            currentMethod.setNonStaticReference();
            return;
        }
        for (MethodReference methodReference : this.methodReferences) {
            methodReference.checkSymbol(symbol);
        }
    }

    private static boolean parentIs(Tree tree, Tree.Kind kind) {
        return tree.parent() != null && tree.parent().is(kind);
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        IdentifierTree identifier;
        Symbol owner;
        if (tree.expression().is(Tree.Kind.IDENTIFIER) && (owner = (identifier = (IdentifierTree)tree.expression()).symbol().owner()) != null && owner.isMethodSymbol()) {
            return;
        }
        super.visitMemberSelectExpression(tree);
    }

    private static class MethodReference {
        private final Symbol.MethodSymbol methodSymbol;
        private final Symbol methodScopeOwner;
        private boolean nonStaticReference = false;

        MethodReference(Symbol.MethodSymbol symbol) {
            this.methodSymbol = symbol;
            this.methodScopeOwner = this.methodSymbol.owner();
            if (this.methodScopeOwner != null && this.methodScopeOwner.isTypeSymbol()) {
                this.nonStaticReference = !this.methodScopeOwner.isStatic() && !this.methodScopeOwner.owner().isPackageSymbol();
            }
        }

        @CheckForNull
        private static Symbol getPackage(Symbol symbol) {
            Symbol owner;
            for (owner = symbol.owner(); owner != null && !owner.isPackageSymbol(); owner = owner.owner()) {
            }
            return owner;
        }

        void setNonStaticReference() {
            this.nonStaticReference = true;
        }

        boolean hasNonStaticReference() {
            return this.nonStaticReference;
        }

        void checkSymbol(Symbol symbol) {
            if (this.nonStaticReference || this.methodSymbol.equals(symbol) || symbol.isStatic()) {
                return;
            }
            Symbol scopeOwner = symbol.owner();
            if (MethodReference.isConstructor(symbol)) {
                this.checkConstructor(scopeOwner);
            } else if (scopeOwner != null) {
                this.checkNonConstructor(scopeOwner);
            }
        }

        private void checkConstructor(Symbol constructorClass) {
            Symbol constructorPackage;
            Symbol methodPackage;
            if (!constructorClass.isStatic() && Objects.equals(methodPackage = MethodReference.getPackage(this.methodScopeOwner), constructorPackage = MethodReference.getPackage(constructorClass)) && !constructorClass.owner().isPackageSymbol()) {
                this.setNonStaticReference();
            }
        }

        private void checkNonConstructor(Symbol scopeOwner) {
            if (scopeOwner.isMethodSymbol()) {
                return;
            }
            if (MethodReference.hasLocalAccess(this.methodScopeOwner, scopeOwner)) {
                this.setNonStaticReference();
            }
        }

        private static boolean isConstructor(Symbol symbol) {
            return "<init>".equals(symbol.name());
        }

        private static boolean hasLocalAccess(Symbol scope, Symbol symbol) {
            Type symbolType;
            Type scopeType;
            if (scope.equals(symbol)) {
                return true;
            }
            return scope.isTypeSymbol() && symbol.isTypeSymbol() && (scopeType = scope.type().erasure()).isSubtypeOf(symbolType = symbol.type().erasure());
        }
    }
}

