/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;

@Rule(key="S5547")
public class StrongCipherAlgorithmCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Use a strong cipher algorithm.";
    private static final Set<String> VULNERABLE_ALGORITHMS = Stream.of("DES", "DESede", "DESedeWrap", "RC2", "ARC2", "RC4", "ARC4", "ARCFOUR", "Blowfish").map(name -> name.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes("javax.crypto.Cipher").names("getInstance").withAnyParameters().build(), MethodMatchers.create().ofTypes("javax.crypto.NullCipher").constructor().withAnyParameters().build());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue(newClassTree.identifier(), MESSAGE);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArg = (ExpressionTree)mit.arguments().get(0);
        ExpressionTree defaultValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArg);
        String firstArgStringValue = ExpressionsHelper.getConstantValueAsString(defaultValue != null ? defaultValue : firstArg).value();
        if (firstArgStringValue != null) {
            this.checkIssue(firstArg, firstArgStringValue);
        }
    }

    private void checkIssue(ExpressionTree argumentForReport, String algorithm) {
        String[] transformationElements = algorithm.split("/");
        if (transformationElements.length > 0 && VULNERABLE_ALGORITHMS.contains(transformationElements[0].toUpperCase(Locale.ROOT))) {
            this.reportIssue(argumentForReport, MESSAGE);
        }
    }
}

