/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6203")
public class TextBlocksInComplexExpressionsCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Move this text block out of the lambda body and refactor it to a local variable or a static final field.";
    private static final int DEFAULT_LINES_NUMBER = 5;
    @RuleProperty(key="MaximumNumberOfLines", description="The maximum number of lines in a text block that can be nested into a complex expression.", defaultValue="5")
    private int linesNumber = 5;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    @Override
    public void visitNode(Tree tree) {
        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
        if (lambdaExpressionTree.parent().is(Tree.Kind.ARGUMENTS)) {
            TextBlockFinder finder = new TextBlockFinder(this.linesNumber);
            lambdaExpressionTree.body().accept(finder);
            finder.misusedTextBlocks.forEach(textBlock -> this.reportIssue((Tree)textBlock, MESSAGE));
        }
    }

    public void setLinesNumber(int linesNumber) {
        this.linesNumber = linesNumber;
    }

    private static final class TextBlockFinder
    extends BaseTreeVisitor {
        private final int maxLines;
        private final List<Tree> misusedTextBlocks = new ArrayList<Tree>();

        public TextBlockFinder(int maxLines) {
            this.maxLines = maxLines;
        }

        @Override
        public void visitLiteral(LiteralTree tree) {
            String value;
            if (tree.is(Tree.Kind.TEXT_BLOCK) && (value = tree.value()).split("\r?\n|\r").length > this.maxLines) {
                this.misusedTextBlocks.add(tree);
            }
        }
    }
}

