/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1448")
public class TooManyMethodsCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM = 35;
    @RuleProperty(key="maximumMethodThreshold", description="The maximum number of methods authorized in a class.", defaultValue="35")
    public int maximumMethodThreshold = 35;
    @RuleProperty(key="countNonpublicMethods", description="Whether or not to include non-public methods in the count.", defaultValue="true")
    public boolean countNonPublic = true;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.RECORD);
    }

    @Override
    public void visitNode(Tree tree) {
        String newTypes;
        String classType;
        ClassTree classTree = (ClassTree)tree;
        List<MethodTree> methods = classTree.members().stream().filter(member -> member.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR)).map(MethodTree.class::cast).filter(method -> this.countNonPublic || method.symbol().isPublic()).collect(Collectors.toList());
        if (this.shouldNotReportIssue(classTree, methods)) {
            return;
        }
        List<JavaFileScannerContext.Location> secondary = methods.stream().map(method -> new JavaFileScannerContext.Location("Method + 1", method.simpleName())).collect(Collectors.toList());
        TypeTree reportTree = ExpressionsHelper.reportOnClassTree(classTree);
        if (TooManyMethodsCheck.isAnonnymousClass(classTree)) {
            classType = "Anonymous class";
            newTypes = "classes";
        } else {
            classType = classTree.declarationKeyword().text();
            newTypes = classType + (tree.is(Tree.Kind.CLASS) ? "es" : "s");
        }
        this.reportIssue(reportTree, String.format("%s \"%s\" has %d%s methods, which is greater than the %d authorized. Split it into smaller %s.", classType, reportTree.symbolType().name(), methods.size(), this.countNonPublic ? "" : " public", this.maximumMethodThreshold, newTypes), secondary, null);
    }

    private boolean shouldNotReportIssue(ClassTree classTree, List<MethodTree> methods) {
        return methods.size() <= this.maximumMethodThreshold || TooManyMethodsCheck.isAnonnymousClass(classTree) && methods.stream().allMatch(TooManyMethodsCheck::isOverriding);
    }

    private static boolean isAnonnymousClass(ClassTree classTree) {
        return classTree.simpleName() == null;
    }

    private static boolean isOverriding(MethodTree methodTree) {
        return !Boolean.FALSE.equals(methodTree.isOverriding());
    }
}

