/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2148")
public class UnderscoreOnNumberCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL);
    }

    @Override
    public void visitNode(Tree tree) {
        LiteralTree literalTree = (LiteralTree)tree;
        String value = literalTree.value();
        if (!UnderscoreOnNumberCheck.containsUnderscore(value) && !UnderscoreOnNumberCheck.isSerialVersionUID(tree) && UnderscoreOnNumberCheck.shouldUseUnderscore(value)) {
            this.reportIssue(literalTree, "Add underscores to this numeric value for readability");
        }
    }

    private static boolean containsUnderscore(String literalValue) {
        return literalValue.indexOf(95) >= 0;
    }

    private static boolean isSerialVersionUID(Tree tree) {
        Tree parent;
        for (parent = tree.parent(); parent != null && !parent.is(Tree.Kind.VARIABLE); parent = parent.parent()) {
        }
        return parent != null && "serialVersionUID".equals(((VariableTree)parent).simpleName().name());
    }

    private static boolean shouldUseUnderscore(String literalValue) {
        String value = LiteralUtils.trimLongSuffix(literalValue);
        Base base = Base.ofLiteralValue(value);
        return value.length() >= base.minimalLength + base.prefix.length();
    }

    private static enum Base {
        BINARY("0b", 9),
        OCTAL("0", 9),
        HEXADECIMAL("0x", 9),
        DECIMAL("", 6);

        private final String prefix;
        private final int minimalLength;

        private Base(String prefix, int minimalLength) {
            this.prefix = prefix;
            this.minimalLength = minimalLength;
        }

        private static final Base ofLiteralValue(String literalValue) {
            if (BINARY.isFromBase(literalValue)) {
                return BINARY;
            }
            if (HEXADECIMAL.isFromBase(literalValue)) {
                return HEXADECIMAL;
            }
            if (OCTAL.isFromBase(literalValue)) {
                return OCTAL;
            }
            return DECIMAL;
        }

        private boolean isFromBase(String value) {
            return value.toLowerCase(Locale.ENGLISH).startsWith(this.prefix);
        }
    }
}

