/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Locale;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00101", repositoryKey="squid")
@Rule(key="S101")
public class BadClassNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String ISSUE_MESSAGE = "Rename this %s name to match the regular expression '%s'.";
    private static final String DEFAULT_FORMAT = "^[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the class names against.", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    public String format = "^[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        if (tree.is(Tree.Kind.CLASS, Tree.Kind.RECORD) && tree.simpleName() != null && !this.pattern.matcher(tree.simpleName().name()).matches()) {
            this.context.reportIssue(this, tree.simpleName(), String.format(ISSUE_MESSAGE, tree.kind().name().toLowerCase(Locale.ROOT), this.format));
        }
        super.visitClass(tree);
    }
}

