/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3577")
public class BadTestClassNameCheck
extends IssuableSubscriptionVisitor {
    private static final String STARTING_WITH_TEST = "(Test|IT)[a-zA-Z0-9_]+";
    private static final String ENDING_WITH_TEST = "[A-Z][a-zA-Z0-9_]*(Test|Tests|TestCase|IT|ITCase)";
    private static final String DEFAULT_FORMAT = "^((Test|IT)[a-zA-Z0-9_]+|[A-Z][a-zA-Z0-9_]*(Test|Tests|TestCase|IT|ITCase))$";
    @RuleProperty(key="format", description="Regular expression against which test class names are checked.", defaultValue="^((Test|IT)[a-zA-Z0-9_]+|[A-Z][a-zA-Z0-9_]*(Test|Tests|TestCase|IT|ITCase))$")
    public String format = "^((Test|IT)[a-zA-Z0-9_]+|[A-Z][a-zA-Z0-9_]*(Test|Tests|TestCase|IT|ITCase))$";
    private Pattern pattern = null;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        IdentifierTree simpleName = classTree.simpleName();
        if (this.hasInvalidName(simpleName) && UnitTestUtils.isTestClass(classTree)) {
            this.reportIssue(simpleName, "Rename class \"" + simpleName.name() + "\" to match the regular expression: '" + this.format + "'");
        }
    }

    private boolean hasInvalidName(@Nullable IdentifierTree className) {
        return className != null && !this.pattern.matcher(className.name()).matches();
    }
}

