/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexScannerContext;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public abstract class AbstractRegexCheck
extends IssuableSubscriptionVisitor
implements RegexCheck {
    protected static final String JAVA_LANG_STRING = "java.lang.String";
    protected static final String LANG3_REGEX_UTILS = "org.apache.commons.lang3.RegExUtils";
    protected static final MethodMatchers REGEX_ON_THE_SECOND_ARGUMENT_METHODS = MethodMatchers.create().ofTypes("org.apache.commons.lang3.RegExUtils").anyName().addParametersMatcher("java.lang.String", "java.lang.String").addParametersMatcher("java.lang.String", "java.lang.String", "java.lang.String").build();
    protected static final MethodMatchers METHODS_IMPLYING_DOT_ALL_FLAG = MethodMatchers.create().ofTypes("org.apache.commons.lang3.RegExUtils").names("removePattern", "replacePattern").withAnyParameters().build();
    private static final MethodMatchers PATTERN_COMPILE = MethodMatchers.create().ofTypes("java.util.regex.Pattern").names("compile").withAnyParameters().build();
    protected static final MethodMatchers REGEX_METHODS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.String").names("matches").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("java.lang.String").names("replaceAll", "replaceFirst", "split").withAnyParameters().build(), PATTERN_COMPILE, MethodMatchers.create().ofTypes("java.util.regex.Pattern").names("matches").withAnyParameters().build(), MethodMatchers.create().ofTypes("org.apache.commons.lang3.RegExUtils").names("removeAll", "removeFirst", "removePattern").addParametersMatcher("java.lang.String", "java.lang.String").build(), MethodMatchers.create().ofTypes("org.apache.commons.lang3.RegExUtils").names("replaceAll", "replaceFirst", "replacePattern").addParametersMatcher("java.lang.String", "java.lang.String", "java.lang.String").build());
    private RegexScannerContext regexContext;
    private final HashSet<RegexSyntaxElement> reportedRegexTrees = new HashSet();

    @Override
    public final void setContext(JavaFileScannerContext context) {
        this.regexContext = (RegexScannerContext)((Object)context);
        this.reportedRegexTrees.clear();
        super.setContext(context);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.ANNOTATION);
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return REGEX_METHODS;
    }

    protected boolean filterAnnotation(AnnotationTree annotation) {
        Type type = annotation.symbolType();
        return type.is("javax.validation.constraints.Pattern") || type.is("javax.validation.constraints.Email") || type.is("org.hibernate.validator.constraints.URL") || type.is("org.hibernate.validator.constraints.Email");
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.ANNOTATION)) {
            AnnotationTree annotation = (AnnotationTree)tree;
            if (this.filterAnnotation(annotation)) {
                this.onAnnotationFound(annotation);
            }
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (this.getMethodInvocationMatchers().matches(mit)) {
                this.onMethodInvocationFound(mit);
            }
        }
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        FlagSet flags;
        ExpressionTree regexExpression = this.getRegexLiteralExpression(mit);
        if (regexExpression != null && !(flags = AbstractRegexCheck.getFlags(mit)).contains(16)) {
            AbstractRegexCheck.getLiterals(regexExpression).map(literals -> this.regexForLiterals(flags, (LiteralTree)literals)).ifPresent(result -> this.checkRegex((RegexParseResult)result, mit));
        }
    }

    @Nullable
    protected ExpressionTree getRegexLiteralExpression(ExpressionTree methodInvocationOrAnnotation) {
        if (methodInvocationOrAnnotation.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mit = (MethodInvocationTree)methodInvocationOrAnnotation;
            int regexIndex = REGEX_ON_THE_SECOND_ARGUMENT_METHODS.matches(mit) ? 1 : 0;
            return regexIndex < mit.arguments().size() ? (ExpressionTree)mit.arguments().get(regexIndex) : null;
        }
        AnnotationTree annotation = (AnnotationTree)methodInvocationOrAnnotation;
        for (ExpressionTree argument : annotation.arguments()) {
            ExpressionTree expression = AbstractRegexCheck.getAnnotationValue(argument, "regexp");
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    protected void onAnnotationFound(AnnotationTree annotation) {
        ExpressionTree regexExpression = this.getRegexLiteralExpression(annotation);
        if (regexExpression != null) {
            AbstractRegexCheck.getLiterals(regexExpression).map(literals -> this.regexForLiterals(AbstractRegexCheck.getFlags(annotation), (LiteralTree)literals)).ifPresent(result -> this.checkRegex((RegexParseResult)result, annotation));
        }
    }

    protected final RegexParseResult regexForLiterals(FlagSet flags, LiteralTree ... literals) {
        return this.regexContext.regexForLiterals(flags, literals);
    }

    @VisibleForTesting
    protected static Optional<LiteralTree[]> getLiterals(ExpressionTree expr) {
        switch (expr.kind()) {
            case PLUS: {
                return AbstractRegexCheck.getLiteralsFromStringConcatenation((BinaryExpressionTree)expr);
            }
            case IDENTIFIER: {
                return AbstractRegexCheck.getLiteralsFromFinalVariables((IdentifierTree)expr);
            }
            case PARENTHESIZED_EXPRESSION: {
                return AbstractRegexCheck.getLiterals(ExpressionUtils.skipParentheses(expr));
            }
            case STRING_LITERAL: 
            case TEXT_BLOCK: {
                return Optional.of(new LiteralTree[]{(LiteralTree)expr});
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)expr;
                if (!PATTERN_COMPILE.matches(mit)) break;
                return AbstractRegexCheck.getLiterals((ExpressionTree)mit.arguments().get(0));
            }
        }
        return Optional.empty();
    }

    private static Optional<LiteralTree[]> getLiteralsFromStringConcatenation(BinaryExpressionTree expr) {
        return AbstractRegexCheck.getLiterals(expr.leftOperand()).flatMap(leftLiterals -> AbstractRegexCheck.getLiterals(expr.rightOperand()).map(rightLiterals -> AbstractRegexCheck.concatenateArrays(leftLiterals, rightLiterals, LiteralTree[]::new)));
    }

    private static <T> T[] concatenateArrays(T[] array1, T[] array2, IntFunction<T[]> arrayConstructor) {
        return Stream.of(array1, array2).flatMap(Arrays::stream).toArray(arrayConstructor);
    }

    protected static Optional<ExpressionTree> getFinalVariableInitializer(IdentifierTree identifier) {
        Symbol symbol = identifier.symbol();
        if (!symbol.isVariableSymbol()) {
            return Optional.empty();
        }
        Symbol.VariableSymbol variableSymbol = (Symbol.VariableSymbol)symbol;
        if (!variableSymbol.isFinal() && !JUtils.isEffectivelyFinal(variableSymbol)) {
            return Optional.empty();
        }
        VariableTree declaration = variableSymbol.declaration();
        if (declaration == null) {
            return Optional.empty();
        }
        ExpressionTree initializer = declaration.initializer();
        if (initializer == null) {
            return Optional.empty();
        }
        return Optional.of(initializer);
    }

    private static Optional<LiteralTree[]> getLiteralsFromFinalVariables(IdentifierTree identifier) {
        return AbstractRegexCheck.getFinalVariableInitializer(identifier).flatMap(AbstractRegexCheck::getLiterals);
    }

    public abstract void checkRegex(RegexParseResult var1, ExpressionTree var2);

    public final void reportIssue(RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        if (this.reportedRegexTrees.add(regexTree)) {
            this.regexContext.reportIssue((RegexCheck)this, regexTree, message, cost, secondaries);
        }
    }

    public Tree methodOrAnnotationName(ExpressionTree methodInvocationOrAnnotation) {
        if (methodInvocationOrAnnotation.is(Tree.Kind.METHOD_INVOCATION)) {
            return ExpressionUtils.methodName((MethodInvocationTree)methodInvocationOrAnnotation);
        }
        return ((AnnotationTree)methodInvocationOrAnnotation).annotationType();
    }

    public final void reportIssue(Tree javaTree, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        this.regexContext.reportIssue((RegexCheck)this, javaTree, message, cost, secondaries);
    }

    protected static Optional<ExpressionTree> getFlagsTree(ExpressionTree methodInvocationOrAnnotation) {
        if (methodInvocationOrAnnotation.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mit = (MethodInvocationTree)methodInvocationOrAnnotation;
            if (mit.symbol().name().equals("compile") && mit.arguments().size() == 2) {
                return Optional.of((ExpressionTree)mit.arguments().get(1));
            }
        } else {
            AnnotationTree annotation = (AnnotationTree)methodInvocationOrAnnotation;
            for (ExpressionTree argument : annotation.arguments()) {
                ExpressionTree expression = AbstractRegexCheck.getAnnotationValue(argument, "flags");
                if (expression == null) continue;
                return Optional.of(expression);
            }
        }
        return Optional.empty();
    }

    private static FlagSet getFlags(MethodInvocationTree mit) {
        if (METHODS_IMPLYING_DOT_ALL_FLAG.matches(mit)) {
            return new FlagSet(32);
        }
        int flags = AbstractRegexCheck.getFlagsTree(mit).flatMap(tree -> tree.asConstant(Integer.class)).orElse(0);
        return new FlagSet(flags);
    }

    private static FlagSet getFlags(AnnotationTree annotation) {
        return AbstractRegexCheck.getFlagsTree(annotation).map(expression -> new AnnotationFlagsVisitor().extractFlags((ExpressionTree)expression)).orElseGet(FlagSet::new);
    }

    @Nullable
    private static ExpressionTree getAnnotationValue(ExpressionTree expression, String parameterName) {
        AssignmentExpressionTree assignment;
        ExpressionTree variable;
        if (expression.is(Tree.Kind.ASSIGNMENT) && (variable = (assignment = (AssignmentExpressionTree)expression).variable()).is(Tree.Kind.IDENTIFIER) && ((IdentifierTree)variable).name().equals(parameterName)) {
            return assignment.expression();
        }
        return null;
    }

    private static class AnnotationFlagsVisitor
    extends BaseTreeVisitor {
        private static final Map<String, Integer> FLAG_MASK = new HashMap<String, Integer>();
        int mask = 0;

        private AnnotationFlagsVisitor() {
        }

        @Override
        public void visitIdentifier(IdentifierTree tree) {
            Type symbolType = tree.symbolType();
            if (symbolType.is("javax.validation.constraints.Pattern$Flag") || symbolType.is("jakarta.validation.constraints.Pattern$Flag")) {
                this.mask |= FLAG_MASK.getOrDefault(tree.name(), 0).intValue();
            }
        }

        FlagSet extractFlags(ExpressionTree flagsExpression) {
            this.mask = 0;
            flagsExpression.accept(this);
            return new FlagSet(this.mask);
        }

        static {
            FLAG_MASK.put("UNIX_LINES", 1);
            FLAG_MASK.put("CASE_INSENSITIVE", 2);
            FLAG_MASK.put("COMMENTS", 4);
            FLAG_MASK.put("MULTILINE", 8);
            FLAG_MASK.put("DOTALL", 32);
            FLAG_MASK.put("UNICODE_CASE", 64);
            FLAG_MASK.put("CANON_EQ", 128);
        }
    }
}

