/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

@Rule(key="S5850")
public class AnchorPrecedenceCheck
extends AbstractRegexCheck {
    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new Visitor().visit(regexForLiterals);
    }

    private class Visitor
    extends RegexBaseVisitor {
        private Visitor() {
        }

        @Override
        public void visitDisjunction(DisjunctionTree tree) {
            List<RegexTree> alternatives = tree.getAlternatives();
            if ((this.anchoredAt(alternatives, Position.BEGINNING) || this.anchoredAt(alternatives, Position.END)) && this.notAnchoredElseWhere(alternatives)) {
                AnchorPrecedenceCheck.this.reportIssue(tree, "Group parts of the regex together to make the intended operator precedence explicit.", null, Collections.emptyList());
            }
            super.visitDisjunction(tree);
        }

        private boolean anchoredAt(List<RegexTree> alternatives, Position position) {
            int itemIndex = position == Position.BEGINNING ? 0 : alternatives.size() - 1;
            RegexTree firstOrLast = alternatives.get(itemIndex);
            return this.isAnchored(firstOrLast, position);
        }

        private boolean notAnchoredElseWhere(List<RegexTree> alternatives) {
            if (this.isAnchored(alternatives.get(0), Position.END) || this.isAnchored(alternatives.get(alternatives.size() - 1), Position.BEGINNING)) {
                return false;
            }
            for (RegexTree alternative : alternatives.subList(1, alternatives.size() - 1)) {
                if (!this.isAnchored(alternative, Position.BEGINNING) && !this.isAnchored(alternative, Position.END)) continue;
                return false;
            }
            return true;
        }

        private boolean isAnchored(RegexTree tree, Position position) {
            if (!tree.is(RegexTree.Kind.SEQUENCE)) {
                return false;
            }
            SequenceTree sequence = (SequenceTree)tree;
            List items = sequence.getItems().stream().filter(item -> !this.isFlagSetter((RegexTree)item)).collect(Collectors.toList());
            if (items.isEmpty()) {
                return false;
            }
            int index = position == Position.BEGINNING ? 0 : items.size() - 1;
            RegexTree firstOrLast = (RegexTree)items.get(index);
            return firstOrLast.is(RegexTree.Kind.BOUNDARY) && this.isAnchor((BoundaryTree)firstOrLast);
        }

        private boolean isAnchor(BoundaryTree tree) {
            switch (tree.type()) {
                case INPUT_START: 
                case LINE_START: 
                case INPUT_END: 
                case INPUT_END_FINAL_TERMINATOR: 
                case LINE_END: {
                    return true;
                }
            }
            return false;
        }

        private boolean isFlagSetter(RegexTree tree) {
            return tree.is(RegexTree.Kind.NON_CAPTURING_GROUP) && ((NonCapturingGroupTree)tree).getElement() == null;
        }
    }

    private static enum Position {
        BEGINNING,
        END;

    }
}

