/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6219")
public class SerialVersionUidInRecordCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.RECORD);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree targetRecord = (ClassTree)tree;
        if (!targetRecord.symbol().type().isSubtypeOf("java.io.Serializable")) {
            return;
        }
        for (Tree member : targetRecord.members()) {
            VariableTree variable;
            if (!member.is(Tree.Kind.VARIABLE) || !SerialVersionUidInRecordCheck.isSerialVersionUIDField(variable = (VariableTree)member) || !SerialVersionUidInRecordCheck.setsTheValueToZero(variable)) continue;
            this.reportIssue(variable, "Remove this redundant \"serialVersionUID\" field");
            return;
        }
    }

    private static boolean isSerialVersionUIDField(VariableTree variable) {
        Symbol symbol = variable.symbol();
        return symbol.isFinal() && symbol.type().is("long") && symbol.name().equals("serialVersionUID");
    }

    private static boolean setsTheValueToZero(VariableTree variable) {
        ExpressionTree initializer = variable.initializer();
        if (initializer == null) {
            return false;
        }
        Optional<Long> longValue = initializer.asConstant(Long.class);
        if (longValue.isPresent()) {
            return longValue.get() == 0L;
        }
        Optional<Integer> integerValue = initializer.asConstant(Integer.class);
        return integerValue.isPresent() && integerValue.get() == 0;
    }
}

