/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.java.AnalysisException;
import org.sonar.java.CheckFailureException;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.ExceptionHandler;
import org.sonar.java.IllegalRuleParameterException;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.exceptions.ThrowableUtils;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Sema;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class VisitorsBridge {
    private static final Logger LOG = Loggers.get(VisitorsBridge.class);
    private final Iterable<? extends JavaCheck> visitors;
    private final List<JavaFileScanner> scanners;
    private final SonarComponents sonarComponents;
    protected InputFile currentFile;
    protected JavaVersion javaVersion;
    private final List<File> classpath;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Collections.singletonList(visitor), new ArrayList<File>(), null);
    }

    public VisitorsBridge(Iterable<? extends JavaCheck> visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        this.visitors = visitors;
        this.scanners = new ArrayList<JavaFileScanner>();
        this.classpath = projectClasspath;
        this.sonarComponents = sonarComponents;
        this.updateScanners();
    }

    private void updateScanners() {
        this.scanners.clear();
        IssuableSubscriptionVisitorsRunner subscriptionVisitorsRunner = null;
        for (JavaCheck javaCheck : this.visitors) {
            if (this.javaVersion != null && javaCheck instanceof JavaVersionAwareVisitor && !((JavaVersionAwareVisitor)((Object)javaCheck)).isCompatibleWithJavaVersion(this.javaVersion)) continue;
            if (javaCheck instanceof IssuableSubscriptionVisitor) {
                if (subscriptionVisitorsRunner == null) {
                    subscriptionVisitorsRunner = new IssuableSubscriptionVisitorsRunner();
                    this.scanners.add(subscriptionVisitorsRunner);
                }
                subscriptionVisitorsRunner.add((IssuableSubscriptionVisitor)javaCheck);
                continue;
            }
            if (!(javaCheck instanceof JavaFileScanner)) continue;
            this.scanners.add((JavaFileScanner)javaCheck);
        }
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public List<File> getClasspath() {
        return this.classpath;
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
        this.updateScanners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitFile(@Nullable Tree parsedTree) {
        boolean fileParsed;
        PerformanceMeasure.Duration compilationUnitDuration = PerformanceMeasure.start("CompilationUnit");
        JavaTree.CompilationUnitTreeImpl tree = new JavaTree.CompilationUnitTreeImpl(null, new ArrayList<ImportClauseTree>(), new ArrayList<Tree>(), null, null);
        compilationUnitDuration.stop();
        PerformanceMeasure.Duration symbolTableDuration = PerformanceMeasure.start("SymbolTable");
        boolean bl = fileParsed = parsedTree != null;
        if (fileParsed && parsedTree.is(Tree.Kind.COMPILATION_UNIT)) {
            tree = (JavaTree.CompilationUnitTreeImpl)parsedTree;
            this.createSonarSymbolTable(tree);
        }
        symbolTableDuration.stop();
        JavaFileScannerContext javaFileScannerContext = this.createScannerContext(tree, tree.sema, this.sonarComponents, fileParsed);
        PerformanceMeasure.Duration scannersDuration = PerformanceMeasure.start("Scanners");
        for (JavaFileScanner scanner : this.scanners) {
            PerformanceMeasure.Duration scannerDuration = PerformanceMeasure.start(scanner);
            try {
                this.runScanner(javaFileScannerContext, scanner);
            }
            catch (CheckFailureException e) {
                this.interruptIfFailFast(e);
            }
            finally {
                scannerDuration.stop();
            }
        }
        scannersDuration.stop();
    }

    private void interruptIfFailFast(CheckFailureException e) {
        if (this.sonarComponents != null && this.sonarComponents.shouldFailAnalysisOnException()) {
            throw new AnalysisException("Failing check", e);
        }
    }

    private void runScanner(JavaFileScannerContext javaFileScannerContext, JavaFileScanner scanner) throws CheckFailureException {
        this.runScanner(() -> scanner.scanFile(javaFileScannerContext), scanner);
    }

    private void runScanner(Runnable action, JavaFileScanner scanner) throws CheckFailureException {
        try {
            action.run();
        }
        catch (IllegalRuleParameterException e) {
            throw new AnalysisException("Bad configuration of rule parameter", e);
        }
        catch (Exception e) {
            Throwable rootCause = ThrowableUtils.getRootCause(e);
            if (rootCause instanceof InterruptedIOException || rootCause instanceof InterruptedException || rootCause instanceof CancellationException || this.analysisCancelled()) {
                throw e;
            }
            String message = String.format("Unable to run check %s - %s on file '%s', To help improve the SonarSource Java Analyzer, please report this problem to SonarSource: see https://community.sonarsource.com/", scanner.getClass(), VisitorsBridge.ruleKey(scanner), this.currentFile);
            LOG.error(message, (Throwable)e);
            throw new CheckFailureException(message, e);
        }
    }

    private boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    private static String ruleKey(JavaFileScanner scanner) {
        Rule annotation = (Rule)AnnotationUtils.getAnnotation(scanner.getClass(), Rule.class);
        if (annotation != null) {
            return annotation.key();
        }
        return "";
    }

    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, @Nullable Sema semanticModel, SonarComponents sonarComponents, boolean fileParsed) {
        return new DefaultJavaFileScannerContext(tree, this.currentFile, semanticModel, sonarComponents, this.javaVersion, fileParsed);
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null && !this.sonarComponents.isSonarLintContext() && !(this.currentFile instanceof GeneratedFile)) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.currentFile));
            symVisitor.visitCompilationUnit(tree);
        }
    }

    public void processRecognitionException(RecognitionException e, InputFile inputFile) {
        if (this.sonarComponents == null || !this.sonarComponents.reportAnalysisError(e, inputFile)) {
            this.visitFile(null);
            this.scanners.stream().filter(ExceptionHandler.class::isInstance).forEach(scanner -> ((ExceptionHandler)((Object)scanner)).processRecognitionException(e));
        }
    }

    public void setCurrentFile(InputFile inputFile) {
        this.currentFile = inputFile;
    }

    public void endOfAnalysis() {
        this.scanners.stream().filter(EndOfAnalysisCheck.class::isInstance).map(EndOfAnalysisCheck.class::cast).forEach(EndOfAnalysisCheck::endOfAnalysis);
    }

    private class IssuableSubscriptionVisitorsRunner
    implements JavaFileScanner,
    EndOfAnalysisCheck {
        private EnumMap<Tree.Kind, List<SubscriptionVisitor>> checks = new EnumMap(Tree.Kind.class);
        private List<SubscriptionVisitor> subscriptionVisitors = new ArrayList<SubscriptionVisitor>();

        IssuableSubscriptionVisitorsRunner() {
        }

        private void add(SubscriptionVisitor subscriptionVisitor) {
            this.subscriptionVisitors.add(subscriptionVisitor);
            subscriptionVisitor.nodesToVisit().forEach(k -> this.checks.computeIfAbsent((Tree.Kind)k, key -> new ArrayList()).add(subscriptionVisitor));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scanFile(JavaFileScannerContext javaFileScannerContext) {
            PerformanceMeasure.Duration issuableSubscriptionVisitorsDuration = PerformanceMeasure.start("IssuableSubscriptionVisitors");
            try {
                this.forEach(this.subscriptionVisitors, s -> s.setContext(javaFileScannerContext));
                this.visit(javaFileScannerContext.getTree());
                this.forEach(this.subscriptionVisitors, s -> s.leaveFile(javaFileScannerContext));
            }
            catch (CheckFailureException e) {
                VisitorsBridge.this.interruptIfFailFast(e);
            }
            finally {
                issuableSubscriptionVisitorsDuration.stop();
            }
        }

        @Override
        public void endOfAnalysis() {
            this.subscriptionVisitors.stream().filter(EndOfAnalysisCheck.class::isInstance).map(EndOfAnalysisCheck.class::cast).forEach(EndOfAnalysisCheck::endOfAnalysis);
        }

        private void visitChildren(Tree tree) throws CheckFailureException {
            JavaTree javaTree = (JavaTree)tree;
            if (!javaTree.isLeaf()) {
                for (Tree next : javaTree.getChildren()) {
                    if (next == null) continue;
                    this.visit(next);
                }
            }
        }

        private void visit(Tree tree) throws CheckFailureException {
            Tree.Kind kind = tree.kind();
            List<SubscriptionVisitor> subscribed = this.checks.getOrDefault(kind, Collections.emptyList());
            boolean isToken = kind == Tree.Kind.TOKEN;
            Consumer<SubscriptionVisitor> callback = isToken ? s -> s.visitToken((SyntaxToken)tree) : s -> s.visitNode(tree);
            this.forEach(subscribed, callback);
            if (isToken) {
                this.forEach(this.checks.getOrDefault(Tree.Kind.TRIVIA, Collections.emptyList()), s -> ((SyntaxToken)tree).trivias().forEach(s::visitTrivia));
            } else {
                this.visitChildren(tree);
            }
            if (!isToken) {
                this.forEach(subscribed, s -> s.leaveNode(tree));
            }
        }

        private final void forEach(Collection<SubscriptionVisitor> visitors, Consumer<SubscriptionVisitor> callback) throws CheckFailureException {
            for (SubscriptionVisitor visitor : visitors) {
                PerformanceMeasure.Duration visitorDuration = PerformanceMeasure.start(visitor);
                VisitorsBridge.this.runScanner(() -> callback.accept(visitor), visitor);
                visitorDuration.stop();
            }
        }
    }
}

