/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.test.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class TestClasspathUtils {
    private TestClasspathUtils() {
    }

    public static Path findModuleJarPath(String modulePath) {
        Path moduleAbsolutePath;
        try {
            moduleAbsolutePath = TestClasspathUtils.toPath(modulePath, new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Module path exception '" + modulePath + "': " + e.getMessage(), e);
        }
        Document pom = TestClasspathUtils.loadXml(moduleAbsolutePath.resolve("pom.xml"));
        String groupId = TestClasspathUtils.xmlNodeValue(pom, "project/groupId/text()|project/parent/groupId/text()");
        String artifactId = TestClasspathUtils.xmlNodeValue(pom, "project/artifactId/text()");
        String version = TestClasspathUtils.xmlNodeValue(pom, "project/version/text()|project/parent/version/text()");
        Path moduleJarPath = moduleAbsolutePath.resolve("target").resolve(artifactId + "-" + version + ".jar");
        if (Files.exists(moduleJarPath, new LinkOption[0])) {
            return moduleJarPath;
        }
        String mavenRepository = TestClasspathUtils.findMavenLocalRepository(System::getenv, System::getProperty);
        Path localRepositoryJarPath = TestClasspathUtils.toPath(mavenRepository, groupId.replace('.', '/'), artifactId, version, artifactId + "-" + version + ".jar");
        if (!Files.exists(localRepositoryJarPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Missing jar for module '" + modulePath + "', not found in '" + String.valueOf(moduleJarPath) + "' nor in '" + String.valueOf(localRepositoryJarPath) + "'");
        }
        return localRepositoryJarPath;
    }

    static Document loadXml(Path xmlPath) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return factory.newDocumentBuilder().parse(xmlPath.toFile());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Exception reading '" + String.valueOf(xmlPath) + "': " + e.getMessage(), e);
        }
    }

    static String xmlNodeValue(Document document, String xpath) {
        try {
            XPathExpression expression = XPathFactory.newInstance().newXPath().compile(xpath);
            Node node = (Node)expression.evaluate(document, XPathConstants.NODE);
            if (node == null) {
                throw new IllegalArgumentException("Missing node for xpath '" + xpath + "'");
            }
            return node.getNodeValue();
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Exception evaluating '" + xpath + "': " + e.getMessage(), e);
        }
    }

    public static List<File> loadFromFile(String classpathTextFilePath) {
        ArrayList<File> classpath = new ArrayList<File>();
        String mavenRepository = TestClasspathUtils.findMavenLocalRepository(System::getenv, System::getProperty);
        try {
            String content = Files.readString(TestClasspathUtils.toPath(classpathTextFilePath, new String[0]), StandardCharsets.UTF_8);
            Arrays.stream(content.split(":")).map(String::trim).filter(line -> !line.isBlank()).map(TestClasspathUtils::fixSeparator).map(line -> line.replace("${M2_REPO}", mavenRepository)).map(x$0 -> Paths.get(x$0, new String[0])).forEach(dependencyPath -> {
                if (!Files.exists(dependencyPath, new LinkOption[0])) {
                    throw new IllegalArgumentException("Missing dependency: " + String.valueOf(dependencyPath));
                }
                classpath.add(dependencyPath.toFile());
            });
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while loading '" + classpathTextFilePath + "': " + e.getMessage(), e);
        }
        return classpath;
    }

    static String findMavenLocalRepository(UnaryOperator<String> systemEnvProvider, UnaryOperator<String> systemPropertyProvider) {
        String repository = (String)systemEnvProvider.apply("M2_REPO");
        if (repository == null || repository.isEmpty()) {
            repository = TestClasspathUtils.toPath((String)systemPropertyProvider.apply("user.home"), ".m2", "repository").toString();
        }
        return repository;
    }

    static String fixSeparator(String path) {
        return path.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar == '/' ? (char)'/' : '\\');
    }

    static Path toPath(String first, String ... more) {
        for (int i = 0; i < more.length; ++i) {
            more[i] = TestClasspathUtils.fixSeparator(more[i]);
        }
        return Paths.get(TestClasspathUtils.fixSeparator(first), more);
    }
}

