/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

public abstract class StringBuildOption<T>
extends AbstractBuildOption<T, CommandLineOptionConfiguration> {
    public StringBuildOption(String gradleProperty) {
        super(gradleProperty);
    }

    public StringBuildOption(String gradleProperty, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(gradleProperty, commandLineOptionConfigurations);
    }

    @Override
    public void applyFromProperty(Map<String, String> properties2, T settings) {
        String value2 = properties2.get(this.gradleProperty);
        if (value2 != null) {
            this.applyTo(value2, settings, Origin.forGradleProperty(this.gradleProperty));
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.isDeprecated(), config.isIncubating()).hasArgument();
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (!options.hasOption(config.getLongOption())) continue;
            String value2 = options.option(config.getLongOption()).getValue();
            this.applyTo(value2, settings, Origin.forCommandLine(config.getLongOption()));
        }
    }

    public abstract void applyTo(String var1, T var2, Origin var3);
}

