/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;

public class ProxyDispatchAdapter<T> {
    private final Class<T> type;
    private final T source;

    public ProxyDispatchAdapter(Dispatch<? super MethodInvocation> dispatch, Class<T> type2, Class<?> ... extraTypes) {
        this.type = type2;
        ArrayList types2 = new ArrayList();
        ClassLoader classLoader = type2.getClassLoader();
        types2.add(type2);
        for (Class<?> extraType : extraTypes) {
            ClassLoader candidate2 = extraType.getClassLoader();
            if (candidate2 != classLoader && candidate2 != null) {
                try {
                    if (candidate2.loadClass(type2.getName()) != null) {
                        classLoader = candidate2;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            types2.add(extraType);
        }
        this.source = type2.cast(Proxy.newProxyInstance(classLoader, types2.toArray(new Class[0]), (InvocationHandler)new DispatchingInvocationHandler(type2, dispatch)));
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getSource() {
        return this.source;
    }

    private static class DispatchingInvocationHandler
    implements InvocationHandler {
        private final Class<?> type;
        private final Dispatch<? super MethodInvocation> dispatch;

        private DispatchingInvocationHandler(Class<?> type2, Dispatch<? super MethodInvocation> dispatch) {
            this.type = type2;
            this.dispatch = dispatch;
        }

        @Override
        public Object invoke(Object target, Method method, Object[] parameters2) throws Throwable {
            if (method.getName().equals("equals")) {
                Object parameter = parameters2[0];
                if (parameter == null || !Proxy.isProxyClass(parameter.getClass())) {
                    return false;
                }
                InvocationHandler handler2 = Proxy.getInvocationHandler(parameter);
                if (!DispatchingInvocationHandler.class.isInstance(handler2)) {
                    return false;
                }
                DispatchingInvocationHandler otherHandler = (DispatchingInvocationHandler)handler2;
                return otherHandler.type.equals(this.type) && otherHandler.dispatch == this.dispatch;
            }
            if (method.getName().equals("hashCode")) {
                return this.dispatch.hashCode();
            }
            if (method.getName().equals("toString")) {
                return this.type.getSimpleName() + " broadcast";
            }
            this.dispatch.dispatch(new MethodInvocation(method, parameters2));
            return null;
        }
    }
}

