/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.Cast;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.util.internal.CollectionUtils;

public abstract class BroadcastDispatch<T>
extends AbstractBroadcastDispatch<T> {
    private BroadcastDispatch(Class<T> type2) {
        super(type2);
    }

    public static <T> BroadcastDispatch<T> empty(Class<T> type2) {
        return new EmptyDispatch<T>(type2);
    }

    public Class<T> getType() {
        return this.type;
    }

    public abstract boolean isEmpty();

    public BroadcastDispatch<T> add(Dispatch<MethodInvocation> dispatch) {
        return this.add(dispatch, dispatch);
    }

    public BroadcastDispatch<T> add(T listener) {
        return this.add(listener, new ReflectionDispatch(listener));
    }

    public BroadcastDispatch<T> add(String methodName, Action<?> action) {
        this.assertIsMethod(methodName);
        return this.add(action, new ActionInvocationHandler(methodName, (Action)Cast.uncheckedNonnullCast(action)));
    }

    abstract BroadcastDispatch<T> add(Object var1, Dispatch<MethodInvocation> var2);

    private void assertIsMethod(String methodName) {
        for (Method method : this.type.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method %s() not found for listener type %s.", methodName, this.type.getSimpleName()));
    }

    public abstract BroadcastDispatch<T> remove(Object var1);

    public abstract BroadcastDispatch<T> addAll(Collection<? extends T> var1);

    public abstract BroadcastDispatch<T> removeAll(Collection<?> var1);

    public abstract void visitListeners(Action<T> var1);

    private static class CompositeDispatch<T>
    extends BroadcastDispatch<T> {
        private final List<SingletonDispatch<T>> dispatchers;

        CompositeDispatch(Class<T> type2, List<SingletonDispatch<T>> dispatchers) {
            super(type2);
            this.dispatchers = dispatchers;
        }

        public String toString() {
            return this.dispatchers.toString();
        }

        @Override
        BroadcastDispatch<T> add(Object handler2, Dispatch<MethodInvocation> dispatch) {
            ArrayList<SingletonDispatch<T>> result2 = new ArrayList<SingletonDispatch<T>>();
            for (SingletonDispatch<T> listener : this.dispatchers) {
                if (((SingletonDispatch)listener).handler == handler2 || ((SingletonDispatch)listener).handler.equals(handler2)) {
                    return this;
                }
                result2.add(listener);
            }
            result2.add(new SingletonDispatch(this.type, handler2, dispatch));
            return new CompositeDispatch<T>(this.type, result2);
        }

        @Override
        public BroadcastDispatch<T> addAll(Collection<? extends T> listeners) {
            ArrayList<SingletonDispatch<T>> result2 = new ArrayList<SingletonDispatch<T>>();
            result2.addAll(this.dispatchers);
            for (T listener : listeners) {
                SingletonDispatch dispatch = new SingletonDispatch(this.type, listener, new ReflectionDispatch(listener));
                if (result2.contains(dispatch)) continue;
                result2.add(dispatch);
            }
            if (result2.equals(this.dispatchers)) {
                return this;
            }
            return new CompositeDispatch<T>(this.type, result2);
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            ArrayList<SingletonDispatch<T>> result2 = new ArrayList<SingletonDispatch<T>>();
            boolean found2 = false;
            for (SingletonDispatch<T> dispatch : this.dispatchers) {
                if (((SingletonDispatch)dispatch).handler == listener || ((SingletonDispatch)dispatch).handler.equals(listener)) {
                    found2 = true;
                    continue;
                }
                result2.add(dispatch);
            }
            if (!found2) {
                return this;
            }
            if (result2.size() == 1) {
                return (BroadcastDispatch)result2.iterator().next();
            }
            return new CompositeDispatch<T>(this.type, result2);
        }

        @Override
        public BroadcastDispatch<T> removeAll(Collection<?> listeners) {
            Set<?> listenerList = CollectionUtils.toSet(listeners);
            ArrayList<SingletonDispatch<T>> result2 = new ArrayList<SingletonDispatch<T>>();
            for (SingletonDispatch<T> dispatch : this.dispatchers) {
                if (listenerList.contains(((SingletonDispatch)dispatch).handler)) continue;
                result2.add(dispatch);
            }
            if (result2.size() == 0) {
                return new EmptyDispatch(this.type);
            }
            if (result2.size() == 1) {
                return (BroadcastDispatch)result2.iterator().next();
            }
            if (result2.equals(this.dispatchers)) {
                return this;
            }
            return new CompositeDispatch<T>(this.type, result2);
        }

        @Override
        public void visitListeners(Action<T> visitor2) {
            for (SingletonDispatch<T> dispatcher : this.dispatchers) {
                dispatcher.visitListeners(visitor2);
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void dispatch(MethodInvocation message2) {
            this.dispatch(message2, this.dispatchers.iterator());
        }
    }

    private static class SingletonDispatch<T>
    extends BroadcastDispatch<T> {
        private final Object handler;
        private final Dispatch<MethodInvocation> dispatch;

        SingletonDispatch(Class<T> type2, Object handler2, Dispatch<MethodInvocation> dispatch) {
            super(type2);
            this.handler = handler2;
            this.dispatch = dispatch;
        }

        public String toString() {
            return this.handler.toString();
        }

        public boolean equals(Object obj) {
            SingletonDispatch other = (SingletonDispatch)Cast.uncheckedNonnullCast(obj);
            return this.handler == other.handler || this.handler.equals(other.handler);
        }

        public int hashCode() {
            return this.handler.hashCode();
        }

        @Override
        BroadcastDispatch<T> add(Object handler2, Dispatch<MethodInvocation> dispatch) {
            if (this.handler == handler2 || this.handler.equals(handler2)) {
                return this;
            }
            ArrayList result2 = new ArrayList();
            result2.add(this);
            result2.add(new SingletonDispatch<T>(this.type, handler2, dispatch));
            return new CompositeDispatch(this.type, result2);
        }

        @Override
        public BroadcastDispatch<T> addAll(Collection<? extends T> listeners) {
            ArrayList result2 = new ArrayList();
            result2.add(this);
            for (T listener : listeners) {
                SingletonDispatch<T> dispatch;
                if (this.handler == listener || this.handler.equals(listener) || result2.contains(dispatch = new SingletonDispatch<T>(this.type, listener, new ReflectionDispatch(listener)))) continue;
                result2.add(dispatch);
            }
            if (result2.size() == 1) {
                return this;
            }
            return new CompositeDispatch(this.type, result2);
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            if (this.handler == listener || this.handler.equals(listener)) {
                return new EmptyDispatch(this.type);
            }
            return this;
        }

        @Override
        public BroadcastDispatch<T> removeAll(Collection<?> listeners) {
            for (Object listener : listeners) {
                if (this.handler != listener && !this.handler.equals(listener)) continue;
                return new EmptyDispatch(this.type);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void visitListeners(Action<T> visitor2) {
            if (this.getType().isInstance(this.handler)) {
                visitor2.execute(this.getType().cast(this.handler));
            }
        }

        @Override
        public void dispatch(MethodInvocation message2) {
            this.dispatch(message2, this.dispatch);
        }
    }

    private static class EmptyDispatch<T>
    extends BroadcastDispatch<T> {
        EmptyDispatch(Class<T> type2) {
            super(type2);
        }

        public String toString() {
            return "<empty>";
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            return this;
        }

        @Override
        public BroadcastDispatch<T> removeAll(Collection<?> listeners) {
            return this;
        }

        @Override
        BroadcastDispatch<T> add(Object handler2, Dispatch<MethodInvocation> dispatch) {
            return new SingletonDispatch(this.type, handler2, dispatch);
        }

        @Override
        public void visitListeners(Action<T> visitor2) {
        }

        @Override
        public BroadcastDispatch<T> addAll(Collection<? extends T> listeners) {
            ArrayList result2 = new ArrayList();
            for (T listener : listeners) {
                SingletonDispatch dispatch = new SingletonDispatch(this.type, listener, new ReflectionDispatch(listener));
                if (result2.contains(dispatch)) continue;
                result2.add(dispatch);
            }
            if (result2.isEmpty()) {
                return this;
            }
            if (result2.size() == 1) {
                return (BroadcastDispatch)result2.iterator().next();
            }
            return new CompositeDispatch(this.type, result2);
        }

        @Override
        public void dispatch(MethodInvocation message2) {
        }
    }

    private static class ActionInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Action<Object> action;

        ActionInvocationHandler(String methodName, Action<Object> action) {
            this.methodName = methodName;
            this.action = action;
        }

        @Override
        public void dispatch(MethodInvocation message2) {
            if (message2.getMethod().getName().equals(this.methodName)) {
                this.action.execute(message2.getArguments()[0]);
            }
        }
    }
}

