/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.RelevantMethods;

class RelevantMethodsBuilder {
    final List<Method> remainingMethods;
    final Class<?> type;
    final LinkedList<Method> decorators = new LinkedList();
    final LinkedList<Method> factories = new LinkedList();
    final LinkedList<Method> configurers = new LinkedList();
    private final Set<String> seen = new HashSet<String>();

    RelevantMethodsBuilder(Class<?> type2) {
        this.type = type2;
        this.remainingMethods = new LinkedList<Method>();
        for (Class<?> clazz = type2; clazz != Object.class && clazz != DefaultServiceRegistry.class; clazz = clazz.getSuperclass()) {
            this.remainingMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
    }

    void add(Iterator<Method> iterator2, List<Method> builder, Method method) {
        StringBuilder signature2 = new StringBuilder();
        signature2.append(method.getName());
        for (Class<?> parameterType : method.getParameterTypes()) {
            signature2.append(",");
            signature2.append(parameterType.getName());
        }
        if (this.seen.add(signature2.toString())) {
            builder.add(method);
        }
        iterator2.remove();
    }

    RelevantMethods build() {
        return new RelevantMethods(this.decorators, this.factories, this.configurers);
    }
}

