/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class TypeInspector {
    private final Set<Class<?>> stopAt = new HashSet();
    private final Map<Class<?>, Set<Class<?>>> inspected = new HashMap();

    public TypeInspector() {
        this.stopAt.add(List.class);
        this.stopAt.add(Set.class);
        this.stopAt.add(Collection.class);
        this.stopAt.add(Map.class);
    }

    public Set<Class<?>> getReachableTypes(Class<?> type2) {
        Set<Class<?>> types2 = this.inspected.get(type2);
        if (types2 == null) {
            types2 = new HashSet();
            this.visit(type2, types2);
            this.inspected.put(type2, types2);
        }
        return types2;
    }

    private void visit(Class<?> type2, Set<Class<?>> types2) {
        if (type2.isArray()) {
            this.visit(type2.getComponentType(), types2);
            return;
        }
        if (!type2.isInterface() || !types2.add(type2) || this.stopAt.contains(type2)) {
            return;
        }
        HashSet<Type> preventEndlessRecursiveSetInClassDefinition = new HashSet<Type>();
        for (Type superType2 : type2.getGenericInterfaces()) {
            this.visit(superType2, types2, preventEndlessRecursiveSetInClassDefinition);
        }
        for (Method method : type2.getDeclaredMethods()) {
            HashSet<Type> methodSet = new HashSet<Type>();
            this.visit(method.getGenericReturnType(), types2, methodSet);
            for (TypeVariable<Method> typeVariable : method.getTypeParameters()) {
                this.visit(typeVariable, types2, methodSet);
            }
        }
    }

    private void visit(Type type2, Set<Class<?>> types2, Set<Type> preventEndlessRecursiveSet) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!preventEndlessRecursiveSet.add(type2)) {
                                return;
                            }
                            if (!(type2 instanceof Class)) break block5;
                            this.visit((Class)type2, types2);
                            break block6;
                        }
                        if (!(type2 instanceof ParameterizedType)) break block7;
                        ParameterizedType parameterizedType = (ParameterizedType)type2;
                        this.visit(parameterizedType.getRawType(), types2, preventEndlessRecursiveSet);
                        for (Type typeArg : parameterizedType.getActualTypeArguments()) {
                            this.visit(typeArg, types2, preventEndlessRecursiveSet);
                        }
                        break block6;
                    }
                    if (!(type2 instanceof WildcardType)) break block8;
                    WildcardType wildcardType = (WildcardType)type2;
                    for (Type bound : wildcardType.getUpperBounds()) {
                        this.visit(bound, types2, preventEndlessRecursiveSet);
                    }
                    for (Type bound : wildcardType.getLowerBounds()) {
                        this.visit(bound, types2, preventEndlessRecursiveSet);
                    }
                    break block6;
                }
                if (!(type2 instanceof GenericArrayType)) break block9;
                GenericArrayType arrayType = (GenericArrayType)type2;
                this.visit(arrayType.getGenericComponentType(), types2, preventEndlessRecursiveSet);
                break block6;
            }
            if (!(type2 instanceof TypeVariable)) break block6;
            TypeVariable typeVariable = (TypeVariable)type2;
            for (Type bound : typeVariable.getBounds()) {
                this.visit(bound, types2, preventEndlessRecursiveSet);
            }
        }
    }
}

