/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.ExceptionTransformer;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.UnsupportedMethodException;

public class DefaultModelBuilder<T>
extends AbstractLongRunningOperation<DefaultModelBuilder<T>>
implements ModelBuilder<T> {
    private final Class<T> modelType;
    private final AsyncConsumerActionExecutor connection;

    public DefaultModelBuilder(Class<T> modelType, AsyncConsumerActionExecutor connection, ConnectionParameters parameters2) {
        super(parameters2);
        this.modelType = modelType;
        this.connection = connection;
        this.operationParamsBuilder.setEntryPoint("ModelBuilder API");
    }

    @Override
    protected DefaultModelBuilder<T> getThis() {
        return this;
    }

    @Override
    public T get() throws GradleConnectionException {
        BlockingResultHandler<T> handler2 = new BlockingResultHandler<T>(this.modelType);
        this.get(handler2);
        return handler2.getResult();
    }

    @Override
    public void get(ResultHandler<? super T> handler2) throws IllegalStateException {
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        this.connection.run(new ConsumerAction<T>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public T run(ConsumerConnection connection) {
                Object model = connection.run(DefaultModelBuilder.this.modelType, operationParameters);
                return model;
            }
        }, new ResultHandlerAdapter<T>(handler2));
    }

    @Override
    public DefaultModelBuilder<T> forTasks(String ... tasks) {
        List<String> rationalizedTasks = DefaultModelBuilder.rationalizeInput(tasks);
        this.operationParamsBuilder.setTasks(rationalizedTasks);
        return this;
    }

    @Override
    public ModelBuilder<T> forTasks(Iterable<String> tasks) {
        this.operationParamsBuilder.setTasks(DefaultModelBuilder.rationalizeInput(tasks));
        return this;
    }

    private class ResultHandlerAdapter<T>
    extends org.gradle.tooling.internal.consumer.ResultHandlerAdapter<T> {
        public ResultHandlerAdapter(ResultHandler<? super T> handler2) {
            super(handler2, new ExceptionTransformer(new Transformer<String, Throwable>(){

                @Override
                public String transform(Throwable failure) {
                    String message2 = String.format("Could not fetch model of type '%s' using %s.", DefaultModelBuilder.this.modelType.getSimpleName(), DefaultModelBuilder.this.connection.getDisplayName());
                    if (!(failure instanceof UnsupportedMethodException) && failure instanceof UnsupportedOperationException) {
                        message2 = message2 + "\nMost likely the model of that type is not supported in the target Gradle version.\nTo resolve the problem you can change/upgrade the Gradle version the tooling api connects to.";
                    }
                    return message2;
                }
            }));
        }
    }
}

