/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestExecutionException;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultDebugOptions;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultInternalJvmTestRequest;
import org.gradle.tooling.internal.consumer.ExceptionTransformer;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.util.internal.CollectionUtils;

public class DefaultTestLauncher
extends AbstractLongRunningOperation<DefaultTestLauncher>
implements TestLauncher {
    private final AsyncConsumerActionExecutor connection;
    private final Set<TestOperationDescriptor> operationDescriptors = new LinkedHashSet<TestOperationDescriptor>();
    private final Set<String> testClassNames = new LinkedHashSet<String>();
    private final Set<InternalJvmTestRequest> internalJvmTestRequests = new LinkedHashSet<InternalJvmTestRequest>();
    private final DefaultDebugOptions debugOptions = new DefaultDebugOptions();
    private final Map<String, List<InternalJvmTestRequest>> tasksAndTests = new HashMap<String, List<InternalJvmTestRequest>>();

    public DefaultTestLauncher(AsyncConsumerActionExecutor connection, ConnectionParameters parameters2) {
        super(parameters2);
        this.operationParamsBuilder.setTasks(Collections.<String>emptyList());
        this.operationParamsBuilder.setEntryPoint("TestLauncher API");
        this.connection = connection;
    }

    @Override
    protected DefaultTestLauncher getThis() {
        return this;
    }

    @Override
    public TestLauncher withTests(TestOperationDescriptor ... testDescriptors) {
        this.withTests(Arrays.asList(testDescriptors));
        return this;
    }

    @Override
    public TestLauncher withTests(Iterable<? extends TestOperationDescriptor> descriptors) {
        this.operationDescriptors.addAll(CollectionUtils.toList(descriptors));
        return this;
    }

    @Override
    public TestLauncher withJvmTestClasses(String ... classNames2) {
        this.withJvmTestClasses(Arrays.asList(classNames2));
        return this;
    }

    @Override
    public TestLauncher withJvmTestClasses(Iterable<String> testClasses) {
        List<InternalJvmTestRequest> newRequests = CollectionUtils.collect(testClasses, new Transformer<InternalJvmTestRequest, String>(){

            @Override
            public InternalJvmTestRequest transform(String testClass) {
                return new DefaultInternalJvmTestRequest(testClass, null);
            }
        });
        this.internalJvmTestRequests.addAll(newRequests);
        this.testClassNames.addAll(CollectionUtils.toList(testClasses));
        return this;
    }

    @Override
    public TestLauncher withJvmTestMethods(String testClass, String ... methods2) {
        this.withJvmTestMethods(testClass, Arrays.asList(methods2));
        return this;
    }

    @Override
    public TestLauncher withJvmTestMethods(final String testClass, Iterable<String> methods2) {
        List<InternalJvmTestRequest> newRequests = CollectionUtils.collect(methods2, new Transformer<InternalJvmTestRequest, String>(){

            @Override
            public InternalJvmTestRequest transform(String methodName) {
                return new DefaultInternalJvmTestRequest(testClass, methodName);
            }
        });
        this.internalJvmTestRequests.addAll(newRequests);
        this.testClassNames.add(testClass);
        return this;
    }

    @Override
    public TestLauncher withTaskAndTestClasses(String task, Iterable<String> testClasses) {
        List<InternalJvmTestRequest> tests = CollectionUtils.collect(testClasses, new Transformer<InternalJvmTestRequest, String>(){

            @Override
            public InternalJvmTestRequest transform(String testClass) {
                return new DefaultInternalJvmTestRequest(testClass, null);
            }
        });
        this.addTests(task, tests);
        return this;
    }

    @Override
    public TestLauncher withTaskAndTestMethods(String task, final String testClass, Iterable<String> methods2) {
        List<InternalJvmTestRequest> tests = CollectionUtils.collect(methods2, new Transformer<InternalJvmTestRequest, String>(){

            @Override
            public InternalJvmTestRequest transform(String methodName) {
                return new DefaultInternalJvmTestRequest(testClass, methodName);
            }
        });
        this.addTests(task, tests);
        return this;
    }

    private void addTests(String task, List<InternalJvmTestRequest> tests) {
        List<InternalJvmTestRequest> existing = this.tasksAndTests.get(task);
        if (existing == null) {
            this.tasksAndTests.put(task, tests);
        } else {
            existing.addAll(tests);
            this.tasksAndTests.put(task, existing);
        }
    }

    @Override
    public TestLauncher debugTestsOn(int port) {
        this.debugOptions.setPort(port);
        return this;
    }

    @Override
    public void run() {
        BlockingResultHandler<Void> handler2 = new BlockingResultHandler<Void>(Void.class);
        this.run(handler2);
        handler2.getResult();
    }

    @Override
    public void run(ResultHandler<? super Void> handler2) {
        if (this.operationDescriptors.isEmpty() && this.internalJvmTestRequests.isEmpty() && this.tasksAndTests.isEmpty()) {
            throw new TestExecutionException("No test declared for execution.");
        }
        for (Map.Entry<String, List<InternalJvmTestRequest>> entry : this.tasksAndTests.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            throw new TestExecutionException("No test for task " + entry.getKey() + " declared for execution.");
        }
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        final TestExecutionRequest testExecutionRequest = new TestExecutionRequest(this.operationDescriptors, ImmutableList.copyOf(this.testClassNames), ImmutableSet.copyOf(this.internalJvmTestRequests), this.debugOptions, ImmutableMap.copyOf(this.tasksAndTests));
        this.connection.run(new ConsumerAction<Void>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public Void run(ConsumerConnection connection) {
                connection.runTests(testExecutionRequest, this.getParameters());
                return null;
            }
        }, new ResultHandlerAdapter(handler2));
    }

    private class ResultHandlerAdapter
    extends org.gradle.tooling.internal.consumer.ResultHandlerAdapter<Void> {
        public ResultHandlerAdapter(ResultHandler<? super Void> handler2) {
            super(handler2, new ExceptionTransformer(new Transformer<String, Throwable>(){

                @Override
                public String transform(Throwable throwable) {
                    return String.format("Could not execute tests using %s.", DefaultTestLauncher.this.connection.getDisplayName());
                }
            }));
        }
    }
}

