/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.DecompiledTryDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aD\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"collectDecompiledTryDescriptors", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/DecompiledTryDescriptor;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "insertSaveRestoreStackMarkers", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "decompiledTryDescriptorForStart", "newTryStartLabels", "", "insertTryCatchBlocksMarkers", "transformTryCatchBlocks", "", "Ljava/util/HashMap;", "debugString", "", "tcb", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "isDefaultHandlerNode", "", "backend"})
@SourceDebugExtension(value={"SMAP\nAnalyzeTryCatchBlocks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeTryCatchBlocks.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/AnalyzeTryCatchBlocksKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Util.kt\norg/jetbrains/kotlin/codegen/optimization/common/UtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,153:1\n1549#2:154\n1620#2,3:155\n1611#2:169\n1855#2:170\n1856#2:172\n1612#2:173\n193#3,5:158\n193#3,5:164\n1#4:163\n1#4:171\n372#5,3:174\n372#5,7:177\n375#5,4:184\n*S KotlinDebug\n*F\n+ 1 AnalyzeTryCatchBlocks.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/AnalyzeTryCatchBlocksKt\n*L\n57#1:154\n57#1:155,3\n121#1:169\n121#1:170\n121#1:172\n121#1:173\n80#1:158,5\n103#1:164,5\n121#1:171\n130#1:174,3\n131#1:177,7\n130#1:184,4\n*E\n"})
public final class AnalyzeTryCatchBlocksKt {
    private static final boolean isDefaultHandlerNode(TryCatchBlockNode $this$isDefaultHandlerNode) {
        return Intrinsics.areEqual($this$isDefaultHandlerNode.start, $this$isDefaultHandlerNode.handler);
    }

    private static final String debugString(MethodNode $this$debugString, TryCatchBlockNode tcb) {
        return "TCB<" + $this$debugString.instructions.indexOf(tcb.start) + ", " + $this$debugString.instructions.indexOf(tcb.end) + ", " + $this$debugString.instructions.indexOf(tcb.handler) + '>';
    }

    @NotNull
    public static final Map<AbstractInsnNode, AbstractInsnNode> insertTryCatchBlocksMarkers(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart = AnalyzeTryCatchBlocksKt.collectDecompiledTryDescriptors(methodNode);
        HashMap<LabelNode, LabelNode> newTryStartLabels = new HashMap<LabelNode, LabelNode>();
        Map<AbstractInsnNode, AbstractInsnNode> restoreStackToSaveStackMarker = AnalyzeTryCatchBlocksKt.insertSaveRestoreStackMarkers(decompiledTryDescriptorForStart, methodNode, (Map<LabelNode, LabelNode>)newTryStartLabels);
        AnalyzeTryCatchBlocksKt.transformTryCatchBlocks(methodNode, newTryStartLabels);
        return restoreStackToSaveStackMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final void transformTryCatchBlocks(MethodNode methodNode, HashMap<LabelNode, LabelNode> newTryStartLabels) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<TryCatchBlockNode> list2 = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue(list2, "methodNode.tryCatchBlocks");
        Iterable iterable = list2;
        MethodNode methodNode2 = methodNode;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tcb;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LabelNode newTryStartLabel = newTryStartLabels.get(tcb.start);
            collection.add(newTryStartLabel == null ? tcb : new TryCatchBlockNode(newTryStartLabel, tcb.end, tcb.handler, tcb.type));
        }
        methodNode2.tryCatchBlocks = (List)destination$iv$iv;
    }

    private static final Map<AbstractInsnNode, AbstractInsnNode> insertSaveRestoreStackMarkers(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, MethodNode methodNode, Map<LabelNode, LabelNode> newTryStartLabels) {
        HashMap restoreStackToSaveMarker = new HashMap();
        HashMap saveStackMarkerByTryLabel = new HashMap();
        HashSet<LabelNode> doneHandlerLabels = new HashSet<LabelNode>();
        Iterator<DecompiledTryDescriptor> iterator2 = decompiledTryDescriptorForStart.values().iterator();
        while (iterator2.hasNext()) {
            DecompiledTryDescriptor decompiledTryDescriptor;
            DecompiledTryDescriptor $this$insertSaveRestoreStackMarkers_u24lambda_u245 = decompiledTryDescriptor = iterator2.next();
            boolean bl = false;
            AbstractInsnNode saveStackMarker = null;
            if (!((Map)saveStackMarkerByTryLabel).containsKey($this$insertSaveRestoreStackMarkers_u24lambda_u245.getTryStartLabel())) {
                AbstractInsnNode nopNode;
                AbstractInsnNode finger$iv;
                AbstractInsnNode $this$findNextOrNull$iv = $this$insertSaveRestoreStackMarkers_u24lambda_u245.getTryStartLabel();
                boolean $i$f$findNextOrNull = false;
                for (finger$iv = $this$findNextOrNull$iv.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                    AbstractInsnNode it = finger$iv;
                    boolean bl2 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                Intrinsics.checkNotNull(finger$iv);
                boolean bl3 = $this$findNextOrNull$iv = nopNode.getOpcode() == 0;
                if (_Assertions.ENABLED && !$this$findNextOrNull$iv) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32 = methodNode.instructions.indexOf(nopNode) + ": try block should start with NOP";
                    throw new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$32);
                }
                LabelNode newTryStartLabel = new LabelNode(new Label());
                newTryStartLabels.put($this$insertSaveRestoreStackMarkers_u24lambda_u245.getTryStartLabel(), newTryStartLabel);
                saveStackMarker = PseudoInsn.SAVE_STACK_BEFORE_TRY.createInsnNode();
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                ((Map)saveStackMarkerByTryLabel).put($this$insertSaveRestoreStackMarkers_u24lambda_u245.getTryStartLabel(), saveStackMarker);
                ((Map)restoreStackToSaveMarker).put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insertBefore(nopNode, saveStackMarker);
                methodNode.instructions.insertBefore(nopNode, newTryStartLabel);
                methodNode.instructions.insert(nopNode, restoreStackMarker);
            } else {
                Object v = saveStackMarkerByTryLabel.get($this$insertSaveRestoreStackMarkers_u24lambda_u245.getTryStartLabel());
                Intrinsics.checkNotNull(v);
                saveStackMarker = (AbstractInsnNode)v;
            }
            for (LabelNode handlerStartLabel : $this$insertSaveRestoreStackMarkers_u24lambda_u245.getHandlerStartLabels()) {
                AbstractInsnNode storeNode;
                AbstractInsnNode finger$iv;
                if (doneHandlerLabels.contains(handlerStartLabel)) continue;
                doneHandlerLabels.add(handlerStartLabel);
                Intrinsics.checkNotNullExpressionValue(handlerStartLabel, "handlerStartLabel");
                AbstractInsnNode $this$findNextOrNull$iv = handlerStartLabel;
                boolean $i$f$findNextOrNull = false;
                for (finger$iv = $this$findNextOrNull$iv.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                    AbstractInsnNode it = finger$iv;
                    boolean bl4 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                Intrinsics.checkNotNull(finger$iv);
                boolean bl5 = $this$findNextOrNull$iv = storeNode.getOpcode() == 58;
                if (_Assertions.ENABLED && !$this$findNextOrNull$iv) {
                    boolean bl6 = false;
                    String string2 = methodNode.instructions.indexOf(storeNode) + ": handler should start with ASTORE";
                    throw new AssertionError((Object)string2);
                }
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                ((Map)restoreStackToSaveMarker).put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insert(storeNode, restoreStackMarker);
            }
        }
        return restoreStackToSaveMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<LabelNode, DecompiledTryDescriptor> collectDecompiledTryDescriptors(MethodNode methodNode) {
        void $this$mapNotNullTo$iv;
        Map decompiledTryDescriptorForStart = new HashMap();
        Map decompiledTryDescriptorForHandler = new HashMap();
        List<TryCatchBlockNode> list2 = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue(list2, "methodNode.tryCatchBlocks");
        Iterable iterable = list2;
        Collection destination$iv = SmartSet.Companion.create();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LabelNode it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl4 = false;
            TryCatchBlockNode it = (TryCatchBlockNode)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            if ((AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(it) ? it.handler : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        SmartSet defaultHandlers = (SmartSet)destination$iv;
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            DecompiledTryDescriptor decompiledTryDescriptor;
            Object object;
            LabelNode key$iv;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullExpressionValue(tcb, "tcb");
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                $i$f$mapNotNullTo = decompiledTryDescriptorForHandler.containsKey(tcb.start);
                if (_Assertions.ENABLED && !$i$f$mapNotNullTo) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb) + ": default handler should occur after some regular handler";
                    throw new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22);
                }
            }
            Map $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = decompiledTryDescriptorForHandler;
            Intrinsics.checkNotNullExpressionValue(tcb.handler, "tcb.handler");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Object object2;
                LabelNode key$iv2;
                void $this$getOrPut$iv2;
                boolean bl = false;
                Map bl4 = decompiledTryDescriptorForStart;
                Intrinsics.checkNotNullExpressionValue(tcb.start, "tcb.start");
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl5 = false;
                    LabelNode labelNode = tcb.start;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.start");
                    DecompiledTryDescriptor answer$iv = new DecompiledTryDescriptor(labelNode);
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                DecompiledTryDescriptor answer$iv = (DecompiledTryDescriptor)object2;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            DecompiledTryDescriptor $this$collectDecompiledTryDescriptors_u24lambda_u2411 = decompiledTryDescriptor = (DecompiledTryDescriptor)object;
            boolean bl = false;
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                boolean bl6;
                boolean bl7 = bl6 = $this$collectDecompiledTryDescriptors_u24lambda_u2411.getDefaultHandlerTcb() == null;
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl8 = false;
                    StringBuilder stringBuilder = new StringBuilder().append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb)).append(": default handler is already found: ");
                    TryCatchBlockNode tryCatchBlockNode = $this$collectDecompiledTryDescriptors_u24lambda_u2411.getDefaultHandlerTcb();
                    Intrinsics.checkNotNull(tryCatchBlockNode);
                    String string2 = stringBuilder.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).toString();
                    throw new AssertionError((Object)string2);
                }
                $this$collectDecompiledTryDescriptors_u24lambda_u2411.setDefaultHandlerTcb(tcb);
            }
            if (defaultHandlers.contains(tcb.handler)) continue;
            $this$collectDecompiledTryDescriptors_u24lambda_u2411.getHandlerStartLabels().add(tcb.handler);
        }
        return decompiledTryDescriptorForStart;
    }
}

