/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionNotApplicableException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.ListenerDescriptor;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusOwner;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusConnectionImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusEx;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageQueue;

class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    private final List<MessageBusImpl> childBuses;
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor;

    CompositeMessageBus(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            CompositeMessageBus.$$$reportNull$$$0(2);
        }
        super(owner);
        this.childBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.topicClassToListenerDescriptor = Collections.emptyMap();
    }

    @Override
    final boolean hasChildren() {
        return !this.childBuses.isEmpty();
    }

    final void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        if (childBus == null) {
            CompositeMessageBus.$$$reportNull$$$0(5);
        }
        boolean removed = this.childBuses.remove(childBus);
        this.rootBus.waitingBuses.get().remove(childBus);
        CompositeMessageBus parentBus = this;
        do {
            parentBus.subscriberCache.clear();
        } while ((parentBus = parentBus.parentBus) != null);
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    final <L> MessageBusImpl.MessagePublisher<L> createPublisher(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(6);
        }
        if (direction == null) {
            CompositeMessageBus.$$$reportNull$$$0(7);
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new MessageBusImpl.ToParentMessagePublisher<L>(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            if (this.parentBus != null) {
                throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic " + topic.getListenerClass() + " broadcast direction to NONE or TO_PARENT");
            }
            return new ToDirectChildrenMessagePublisher<L>(topic, this);
        }
        return new MessageBusImpl.MessagePublisher<L>(topic, this);
    }

    @Override
    final @Nullable Object @NotNull [] computeSubscribers(@NotNull Topic<?> topic) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(8);
        }
        if (this.owner.isDisposed()) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                CompositeMessageBus.$$$reportNull$$$0(9);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = super.computeSubscribers(topic);
        if (objectArray == null) {
            CompositeMessageBus.$$$reportNull$$$0(10);
        }
        return objectArray;
    }

    @Override
    final void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result2, boolean subscribeLazyListeners) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            CompositeMessageBus.$$$reportNull$$$0(12);
        }
        if (subscribeLazyListeners) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers(topic, result2, subscribeLazyListeners);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers(topic, result2, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private <L> void subscribeLazyListeners(@NotNull Topic<L> topic) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(13);
        }
        if (topic.getListenerClass() == Runnable.class) {
            return;
        }
        List<ListenerDescriptor> listenerDescriptors = this.topicClassToListenerDescriptor.remove(topic.getListenerClass().getName());
        if (listenerDescriptors == null) {
            return;
        }
        LinkedHashMap<PluginDescriptor, List> listenerMap = new LinkedHashMap<PluginDescriptor, List>();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                listenerMap.computeIfAbsent(listenerDescriptor.pluginDescriptor, __ -> new ArrayList()).add(this.owner.createListener(listenerDescriptor));
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach((key, listeners) -> this.subscribers.add(new DescriptorBasedMessageBusConnection((PluginDescriptor)key, topic, listeners)));
    }

    @Override
    final void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        if (topic == null) {
            CompositeMessageBus.$$$reportNull$$$0(14);
        }
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    @Override
    final boolean notifyConnectionTerminated(Object @NotNull [] topicAndHandlerPairs) {
        boolean isChildClearingNeeded;
        if (topicAndHandlerPairs == null) {
            CompositeMessageBus.$$$reportNull$$$0(15);
        }
        if (!(isChildClearingNeeded = super.notifyConnectionTerminated(topicAndHandlerPairs))) {
            return false;
        }
        this.childBuses.forEach(childBus -> childBus.clearSubscriberCache(topicAndHandlerPairs));
        Set<MessageBusImpl> waitingBuses = this.rootBus.waitingBuses.get();
        if (!waitingBuses.isEmpty()) {
            waitingBuses.removeIf(bus -> {
                MessageQueue messageQueue = bus.messageQueue.get();
                Deque<Message> queue = messageQueue.queue;
                return !queue.isEmpty() && queue.removeIf(message2 -> MessageBusConnectionImpl.nullizeHandlersFromMessage(message2, topicAndHandlerPairs)) && messageQueue.current == null && queue.isEmpty();
            });
        }
        return false;
    }

    @Override
    final void clearSubscriberCache(Object @NotNull [] topicAndHandlerPairs) {
        if (topicAndHandlerPairs == null) {
            CompositeMessageBus.$$$reportNull$$$0(16);
        }
        super.clearSubscriberCache(topicAndHandlerPairs);
        this.childBuses.forEach(childBus -> childBus.clearSubscriberCache(topicAndHandlerPairs));
    }

    @Override
    final void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        this.childBuses.forEach(MessageBusImpl::removeEmptyConnectionsRecursively);
    }

    @Override
    protected final void disposeChildren() {
        this.childBuses.forEach(Disposer::dispose);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBus";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/CompositeMessageBus";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topicAndHandlerPairs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerDescriptors";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/CompositeMessageBus";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSubscribers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLazyListeners";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusDisposed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeSubscribers";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doComputeSubscribers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "subscribeLazyListeners";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscriptionToTopicToChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCache";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unsubscribeLazyListeners";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "disconnectPluginConnections";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ToDirectChildrenMessagePublisher<L>
    extends MessageBusImpl.MessagePublisher<L>
    implements InvocationHandler {
        ToDirectChildrenMessagePublisher(@NotNull Topic<L> topic, @NotNull CompositeMessageBus bus) {
            if (topic == null) {
                ToDirectChildrenMessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                ToDirectChildrenMessagePublisher.$$$reportNull$$$0(1);
            }
            super(topic, bus);
        }

        @Override
        boolean publish(@NotNull Method method, Object[] args2, @Nullable MessageQueue jobQueue) {
            if (method == null) {
                ToDirectChildrenMessagePublisher.$$$reportNull$$$0(2);
            }
            List<Throwable> exceptions = null;
            boolean hasHandlers = false;
            @Nullable Object @NotNull [] handlers = this.bus.subscriberCache.computeIfAbsent(this.topic, topic1 -> this.bus.computeSubscribers((Topic<?>)topic1));
            if (handlers.length != 0) {
                exceptions = ToDirectChildrenMessagePublisher.executeOrAddToQueue(this.topic, method, args2, handlers, jobQueue, this.bus.messageDeliveryListener, null);
                hasHandlers = true;
            }
            for (MessageBusImpl childBus : ((CompositeMessageBus)this.bus).childBuses) {
                if (childBus.owner.isDisposed() || (handlers = childBus.subscriberCache.computeIfAbsent(this.topic, topic1 -> {
                    ArrayList<Object> result2 = new ArrayList<Object>();
                    childBus.doComputeSubscribers((Topic<?>)topic1, (List<Object>)result2, !childBus.owner.isParentLazyListenersIgnored());
                    return result2.isEmpty() ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : result2.toArray();
                })).length == 0) continue;
                hasHandlers = true;
                exceptions = ToDirectChildrenMessagePublisher.executeOrAddToQueue(this.topic, method, args2, handlers, jobQueue, this.bus.messageDeliveryListener, exceptions);
            }
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/CompositeMessageBus$ToDirectChildrenMessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

