/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.NavigatablePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies$DOT_BY_QUALIFIED$1$mark$lambda$1$;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u0097\u0001\u0098\u0001\u0099\u0001\u009a\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0016\u0010\u0090\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u0092\u00010\u0091\u0001\"\u00030\u0092\u0001H\u0007\u00a2\u0006\u0003\u0010\u0093\u0001J\u000f\u0010\u0094\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0010\u0010\u0095\u0001\u001a\u0004\u0018\u00010\u0019*\u00030\u0096\u0001H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\tR\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\tR\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\tR\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\tR\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\tR\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\tR\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\tR\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020O0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\tR\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020Y0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020]0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\tR\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020&0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020&0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\tR\u0017\u0010f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\tR\u0017\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\tR\u0016\u0010j\u001a\b\u0012\u0004\u0012\u00020k0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010\tR\u0016\u0010p\u001a\b\u0012\u0004\u0012\u00020T0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010\tR\u0016\u0010s\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010v\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010\tR\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010y\u001a\b\u0012\u0004\u0012\u00020z0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010{\u001a\b\u0012\u0004\u0012\u00020z0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010}\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010~\u001a\b\u0012\u0004\u0012\u00020\u007f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0084\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0001\u0010\tR\u001b\u0010\u0088\u0001\u001a\t0\u0089\u0001\u00a2\u0006\u0003\b\u008a\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001b\u0010\u008d\u0001\u001a\t0\u0089\u0001\u00a2\u0006\u0003\b\u008a\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008e\u0001\u0010\u008c\u0001\u00a8\u0006\u009b\u0001"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "ANNOTATION_USE_SITE", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getANNOTATION_USE_SITE", "()Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "CALL_ELEMENT", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "CALL_ELEMENT_WITH_DOT", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "CALL_EXPRESSION", "COMMAS", "getCOMMAS$annotations", "getCOMMAS", "COMPANION_OBJECT", "CONST_MODIFIER", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "DATA_MODIFIER", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_START_TO_NAME", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "DEFAULT", "DELEGATED_SUPERTYPE_BY_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getDELEGATED_SUPERTYPE_BY_KEYWORD", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "DOT_BY_QUALIFIED", "getDOT_BY_QUALIFIED", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "ENUM_MODIFIER", "FIELD_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtBackingField;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "FUN_INTERFACE", "FUN_MODIFIER", "IF_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "IMPORT_LAST_NAME", "getIMPORT_LAST_NAME", "INLINE_FUN_MODIFIER", "INLINE_OR_VALUE_MODIFIER", "INLINE_PARAMETER_MODIFIER", "INNER_MODIFIER", "LABEL", "getLABEL", "LATEINIT_MODIFIER", "LONG_LITERAL_SUFFIX", "MODALITY_MODIFIER", "NAME_IDENTIFIER", "getNAME_IDENTIFIER", "NAME_OF_NAMED_ARGUMENT", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "NON_FINAL_MODIFIER_OR_NAME", "getNON_FINAL_MODIFIER_OR_NAME", "NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "OBJECT_KEYWORD", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "OPEN_MODIFIER", "OPERATOR", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getOPERATOR", "OPERATOR_MODIFIER", "OVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "PROPERTY_DELEGATE", "Lorg/jetbrains/kotlin/psi/KtProperty;", "PROPERTY_INITIALIZER", "getPROPERTY_INITIALIZER", "QUESTION_MARK_BY_TYPE", "RECEIVER", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "REDUNDANT_NULLABLE", "REFERENCED_NAME_BY_QUALIFIED", "getREFERENCED_NAME_BY_QUALIFIED", "REFERENCE_BY_QUALIFIED", "getREFERENCE_BY_QUALIFIED", "REIFIED_MODIFIER", "getREIFIED_MODIFIER", "RETURN_WITH_LABEL", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "SAFE_ACCESS", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "SELECTOR_BY_QUALIFIED", "getSELECTOR_BY_QUALIFIED", "SPECIAL_CONSTRUCT_TOKEN", "SPREAD_OPERATOR", "getSPREAD_OPERATOR", "SUPERTYPES_LIST", "SUSPEND_MODIFIER", "TAILREC_MODIFIER", "TYPE_PARAMETERS_LIST", "getTYPE_PARAMETERS_LIST", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "VALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "VARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "WHOLE_ELEMENT", "getWHOLE_ELEMENT", "classKindTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getClassKindTokens", "()Lcom/intellij/psi/tree/TokenSet;", "propertyKindTokens", "getPropertyKindTokens", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "projectionPosition", "getReferencedTypeExpression", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "DeclarationHeader", "FindReferencePositioningStrategy", "InlineFunPositioningStrategy", "ModifierSetBasedPositioningStrategy", "frontend.common-psi"})
public final class PositioningStrategies {
    @NotNull
    public static final PositioningStrategies INSTANCE = new PositioningStrategies();
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            PsiElement psiElement = element;
            if (psiElement instanceof KtObjectLiteralExpression) {
                KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)element).getObjectDeclaration();
                Intrinsics.checkNotNullExpressionValue(ktObjectDeclaration, "element.objectDeclaration");
                KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
                PsiElement psiElement2 = objectDeclaration.getObjectKeyword();
                Intrinsics.checkNotNull(psiElement2);
                PsiElement objectKeyword = psiElement2;
                KtSuperTypeList ktSuperTypeList = objectDeclaration.getSuperTypeList();
                if (ktSuperTypeList == null) {
                    return PositioningStrategyKt.markElement(objectKeyword);
                }
                KtSuperTypeList delegationSpecifierList = ktSuperTypeList;
                return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
            }
            if (psiElement instanceof KtObjectDeclaration) {
                PsiElement psiElement3 = ((KtObjectDeclaration)element).getObjectKeyword();
                Intrinsics.checkNotNull(psiElement3);
                PsiElement psiElement4 = ((KtObjectDeclaration)element).getNameIdentifier();
                if (psiElement4 == null) {
                    PsiElement psiElement5 = ((KtObjectDeclaration)element).getObjectKeyword();
                    psiElement4 = psiElement5;
                    Intrinsics.checkNotNull(psiElement5);
                }
                Intrinsics.checkNotNullExpressionValue(psiElement4, "element.nameIdentifier ?\u2026ment.getObjectKeyword()!!");
                return PositioningStrategyKt.markRange(psiElement3, psiElement4);
            }
            if (psiElement instanceof KtConstructorDelegationCall) {
                return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark(element);
            }
            return super.mark(element);
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SUPERTYPES_LIST = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            KtClass ktClass = element instanceof KtClass ? (KtClass)element : null;
            if (ktClass == null) {
                return PositioningStrategyKt.markElement(element);
            }
            List<KtSuperTypeListEntry> supertypes2 = ktClass.getSuperTypeListEntries();
            return supertypes2.isEmpty() ? PositioningStrategyKt.markElement(element) : PositioningStrategyKt.markRange(supertypes2.get(0), CollectionsKt.last(supertypes2));
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

        @NotNull
        public List<TextRange> mark(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter(element, "element");
            return PositioningStrategyKt.markElement(this.getElementToMark(element));
        }

        public boolean isValid(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter(element, "element");
            return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
        }

        private final PsiElement getElementToMark(KtDeclaration declaration) {
            KtDeclaration ktDeclaration = declaration;
            Pair<KtTypeReference, PsiElement> pair = ktDeclaration instanceof KtCallableDeclaration ? new Pair<KtTypeReference, PsiElement>(((KtCallableDeclaration)declaration).getTypeReference(), ((KtCallableDeclaration)declaration).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair<KtTypeReference, PsiElement>(((KtPropertyAccessor)declaration).getReturnTypeReference(), ((KtPropertyAccessor)declaration).getNamePlaceholder()) : new Pair<Object, Object>(null, null));
            KtTypeReference returnTypeRef = pair.component1();
            PsiElement nameIdentifierOrPlaceholder = pair.component2();
            if (returnTypeRef != null) {
                return returnTypeRef;
            }
            if (nameIdentifierOrPlaceholder != null) {
                return nameIdentifierOrPlaceholder;
            }
            return declaration;
        }
    };
    @NotNull
    private static final TokenSet propertyKindTokens;
    @NotNull
    private static final TokenSet classKindTokens;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_START_TO_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPEN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> LATEINIT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> CONST_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> SUSPEND_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> DATA_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPERATOR_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ENUM_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> TAILREC_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> OBJECT_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBackingField> FIELD_KEYWORD;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtProperty> PROPERTY_DELEGATE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SAFE_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> MODALITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_OR_VALUE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INNER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_PARAMETER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_VARARG_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtValueArgument> NAME_OF_NAMED_ARGUMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtQualifiedExpression> CALL_ELEMENT_WITH_DOT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtIfExpression> IF_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtExpression> SPECIAL_CONSTRUCT_TOKEN;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeReference> REDUNDANT_NULLABLE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeReference> QUESTION_MARK_BY_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReturnExpression> RETURN_WITH_LABEL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtCallableDeclaration> RECEIVER;
    @NotNull
    private static final PositioningStrategy<KtExpression> OPERATOR;
    @NotNull
    private static final PositioningStrategy<PsiElement> DOT_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> SELECTOR_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> NAME_IDENTIFIER;
    @NotNull
    private static final PositioningStrategy<PsiElement> SPREAD_OPERATOR;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> FUN_INTERFACE;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCE_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCED_NAME_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> REIFIED_MODIFIER;
    @NotNull
    private static final PositioningStrategy<KtProperty> PROPERTY_INITIALIZER;
    @NotNull
    private static final PositioningStrategy<KtElement> WHOLE_ELEMENT;
    @NotNull
    private static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_LIST;
    @NotNull
    private static final PositioningStrategy<KtAnnotationEntry> ANNOTATION_USE_SITE;
    @NotNull
    private static final PositioningStrategy<PsiElement> IMPORT_LAST_NAME;
    @NotNull
    private static final PositioningStrategy<KtElement> LABEL;
    @NotNull
    private static final PositioningStrategy<PsiElement> COMMAS;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> NON_FINAL_MODIFIER_OR_NAME;
    @NotNull
    private static final PositioningStrategy<KtTypeReference> DELEGATED_SUPERTYPE_BY_KEYWORD;

    private PositioningStrategies() {
    }

    @NotNull
    public final TokenSet getPropertyKindTokens() {
        return propertyKindTokens;
    }

    @NotNull
    public final TokenSet getClassKindTokens() {
        return classKindTokens;
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkNotNullParameter(tokens, "tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;
            {
                this.$tokens = $tokens;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtModifierList ktModifierList = element.getModifierList();
                if (ktModifierList == null) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                KtModifierList modifierList2 = ktModifierList;
                for (KtModifierKeywordToken token : this.$tokens) {
                    PsiElement modifier = modifierList2.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> projectionPosition() {
        return new PositioningStrategy<KtModifierListOwner>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtTypeProjection && ((KtTypeProjection)element).getProjectionKind() == KtProjectionKind.STAR) {
                    return PositioningStrategyKt.markElement(element);
                }
                KtModifierList $this$sure$iv = element.getModifierList();
                boolean $i$f$sure = false;
                KtModifierList ktModifierList = $this$sure$iv;
                if (ktModifierList == null) {
                    boolean bl = false;
                    String string2 = "No modifier list, but modifier has been found by the analyzer";
                    throw new AssertionError((Object)string2);
                }
                Intrinsics.checkNotNullExpressionValue(ktModifierList, "element.modifierList.sur\u2026 found by the analyzer\" }");
                KtModifierList modifierList2 = ktModifierList;
                PsiElement psiElement = modifierList2.getModifier(KtTokens.IN_KEYWORD);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                psiElement = modifierList2.getModifier(KtTokens.OUT_KEYWORD);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                throw new IllegalStateException("None of the modifiers is found: in, out");
            }
        };
    }

    @NotNull
    public final PositioningStrategy<KtExpression> getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDOT_BY_QUALIFIED() {
        return DOT_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSELECTOR_BY_QUALIFIED() {
        return SELECTOR_BY_QUALIFIED;
    }

    private final KtElement getReferencedTypeExpression(KtTypeElement $this$getReferencedTypeExpression) {
        KtElement ktElement;
        KtTypeElement ktTypeElement = $this$getReferencedTypeExpression;
        if (ktTypeElement instanceof KtUserType) {
            ktElement = ((KtUserType)$this$getReferencedTypeExpression).getReferenceExpression();
        } else if (ktTypeElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement2 = ((KtNullableType)$this$getReferencedTypeExpression).getInnerType();
            ktElement = ktTypeElement2 != null ? this.getReferencedTypeExpression(ktTypeElement2) : null;
        } else {
            ktElement = null;
        }
        return ktElement;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getNAME_IDENTIFIER() {
        return NAME_IDENTIFIER;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSPREAD_OPERATOR() {
        return SPREAD_OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCE_BY_QUALIFIED() {
        return REFERENCE_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCED_NAME_BY_QUALIFIED() {
        return REFERENCED_NAME_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getREIFIED_MODIFIER() {
        return REIFIED_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtProperty> getPROPERTY_INITIALIZER() {
        return PROPERTY_INITIALIZER;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getWHOLE_ELEMENT() {
        return WHOLE_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getTYPE_PARAMETERS_LIST() {
        return TYPE_PARAMETERS_LIST;
    }

    @NotNull
    public final PositioningStrategy<KtAnnotationEntry> getANNOTATION_USE_SITE() {
        return ANNOTATION_USE_SITE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getIMPORT_LAST_NAME() {
        return IMPORT_LAST_NAME;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getLABEL() {
        return LABEL;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCOMMAS() {
        return COMMAS;
    }

    public static /* synthetic */ void getCOMMAS$annotations() {
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getNON_FINAL_MODIFIER_OR_NAME() {
        return NON_FINAL_MODIFIER_OR_NAME;
    }

    @NotNull
    public final PositioningStrategy<KtTypeReference> getDELEGATED_SUPERTYPE_BY_KEYWORD() {
        return DELEGATED_SUPERTYPE_BY_KEYWORD;
    }

    public static final /* synthetic */ KtElement access$getReferencedTypeExpression(PositioningStrategies $this, KtTypeElement $receiver) {
        return $this.getReferencedTypeExpression($receiver);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD)");
        propertyKindTokens = tokenSet;
        iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet2 = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet2, "create(KtTokens.CLASS_KE\u2026Tokens.INTERFACE_KEYWORD)");
        classKindTokens = tokenSet2;
        DECLARATION_START_TO_NAME = new DeclarationHeader<KtDeclaration>(){

            private final PsiElement firstNonCommentNonAnnotationLeaf(PsiElement $this$firstNonCommentNonAnnotationLeaf) {
                PsiElement leaf;
                PsiElement psiElement = $this$firstNonCommentNonAnnotationLeaf.getFirstChild();
                if (psiElement == null) {
                    return $this$firstNonCommentNonAnnotationLeaf;
                }
                PsiElement child = psiElement;
                while (true) {
                    if (child instanceof PsiComment || child instanceof PsiWhiteSpace || child instanceof KtAnnotationEntry) {
                        child = child.getNextSibling();
                        continue;
                    }
                    if (child == null) {
                        return null;
                    }
                    leaf = this.firstNonCommentNonAnnotationLeaf(child);
                    if (leaf != null) break;
                    child = child.getNextSibling();
                }
                return leaf;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                List<TextRange> list2;
                PsiElement nameIdentifier;
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = this.firstNonCommentNonAnnotationLeaf(element);
                if (psiElement == null) {
                    psiElement = element;
                }
                PsiElement startElement = psiElement;
                KtNamedDeclaration ktNamedDeclaration = element instanceof KtNamedDeclaration ? (KtNamedDeclaration)element : null;
                PsiElement psiElement2 = nameIdentifier = ktNamedDeclaration != null ? ktNamedDeclaration.getNameIdentifier() : null;
                if (nameIdentifier != null) {
                    list2 = PositioningStrategyKt.markRange(startElement, nameIdentifier);
                } else {
                    KtDeclaration ktDeclaration = element;
                    if (ktDeclaration instanceof KtConstructor) {
                        PsiElement psiElement3 = ((KtConstructor)element).getConstructorKeyword();
                        if (psiElement3 == null) {
                            psiElement3 = element;
                        }
                        list2 = PositioningStrategyKt.markRange(startElement, psiElement3);
                    } else if (ktDeclaration instanceof KtObjectDeclaration) {
                        PsiElement psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                        if (psiElement4 == null) {
                            psiElement4 = element;
                        }
                        list2 = PositioningStrategyKt.markRange(startElement, psiElement4);
                    } else {
                        list2 = PositioningStrategies.DEFAULT.mark(element);
                    }
                }
                return list2;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof KtClassOrObject) {
                        PsiElement psiElement = element.getModifierList();
                        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                            IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                            ASTNode aSTNode = ((KtClassOrObject)element).getNode().findChildByType(TokenSet.create(iElementTypeArray));
                            psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                            if (psiElement == null) {
                                psiElement = element;
                            }
                        }
                        PsiElement startElement = psiElement;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtConstructor) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        KtParameterList ktParameterList = ((KtConstructor)element).getValueParameterList();
                        if (ktParameterList != null) {
                            psiElement2 = ktParameterList;
                        } else {
                            return PositioningStrategyKt.markElement(element);
                        }
                    }
                    PsiElement begin = psiElement2;
                    KtParameterList ktParameterList = ((KtConstructor)element).getValueParameterList();
                    if (ktParameterList != null) {
                        psiElement = ktParameterList;
                    } else {
                        psiElement = ((KtConstructor)element).getConstructorKeyword();
                        if (psiElement == null) {
                            return PositioningStrategyKt.markElement(element);
                        }
                    }
                    PsiElement end = psiElement;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    KtElement ktElement;
                    PsiElement endOfSignatureElement;
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtFunction)element).getTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        KtParameterList ktParameterList = ((KtFunction)element).getValueParameterList();
                        if (ktParameterList != null) {
                            psiElement = ktParameterList;
                        } else {
                            psiElement = ((KtFunction)element).getNameIdentifier();
                            if (psiElement == null) {
                                psiElement = endOfSignatureElement = (PsiElement)element;
                            }
                        }
                    }
                    if (element instanceof KtFunctionLiteral) {
                        NavigatablePsiElement navigatablePsiElement;
                        KtTypeReference ktTypeReference2 = ((KtFunction)element).getReceiverTypeReference();
                        if (ktTypeReference2 != null) {
                            navigatablePsiElement = ktTypeReference2;
                        } else {
                            KtParameterList ktParameterList = ((KtFunction)element).getValueParameterList();
                            navigatablePsiElement = ktParameterList != null ? (NavigatablePsiElement)ktParameterList : (NavigatablePsiElement)element;
                        }
                        ktElement = (KtElement)navigatablePsiElement;
                    } else {
                        ktElement = element;
                    }
                    KtElement startElement = ktElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtProperty)element).getTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        psiElement = ((KtProperty)element).getNameIdentifier();
                        if (psiElement == null) {
                            psiElement = element;
                        }
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element).getReturnTypeReference();
                    if (ktTypeReference != null) {
                        psiElement = ktTypeReference;
                    } else {
                        psiElement = ((KtPropertyAccessor)element).getRightParenthesis();
                        if (psiElement == null) {
                            psiElement = ((KtPropertyAccessor)element).getNamePlaceholder();
                        }
                    }
                    PsiElement startElement = psiElement;
                    Intrinsics.checkNotNullExpressionValue(startElement, "element.returnTypeRefere\u2026: element.namePlaceholder");
                    PsiElement endOfSignatureElement = startElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement psiElement = ((KtClass)element).getNameIdentifier();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = psiElement;
                    KtParameterList ktParameterList = ((KtClass)element).getPrimaryConstructorParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(nameAsDeclaration);
                    }
                    KtParameterList primaryConstructorParameterList = ktParameterList;
                    return PositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element);
                }
                if (ktDeclaration instanceof KtClassInitializer) {
                    TextRange textRange2 = ((KtClassInitializer)element).getInitKeyword().getTextRange();
                    Intrinsics.checkNotNullExpressionValue(textRange2, "element.initKeyword.textRange");
                    return PositioningStrategyKt.markRange(textRange2);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element) : PositioningStrategies.DEFAULT.mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element) : PositioningStrategies.DEFAULT.isValid(element);
            }
        };
        NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element, "element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClassOrObject) {
                    psiElement = ((KtClassOrObject)element).getDeclarationKeyword();
                    if (psiElement == null && (psiElement = ((KtClassOrObject)element).getNameIdentifier()) == null) {
                        psiElement = element;
                    }
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    psiElement = ((KtNamedFunction)element).getModifierList();
                    if ((psiElement == null || (psiElement = ((KtModifierList)psiElement).getModifier(KtTokens.INLINE_KEYWORD)) == null) && (psiElement = ((KtNamedFunction)element).getFunKeyword()) == null) {
                        psiElement = element;
                    }
                } else {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                KtTypeParameterList ktTypeParameterList;
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtTypeParameterListOwner && (ktTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(ktTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
            }
        };
        IElementType[] iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.ABSTRACT_KEYWORD, "ABSTRACT_KEYWORD");
        ABSTRACT_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.OPEN_KEYWORD, "OPEN_KEYWORD");
        OPEN_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.OVERRIDE_KEYWORD, "OVERRIDE_KEYWORD");
        OVERRIDE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.PRIVATE_KEYWORD, "PRIVATE_KEYWORD");
        PRIVATE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.LATEINIT_KEYWORD, "LATEINIT_KEYWORD");
        LATEINIT_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        VARIANCE_MODIFIER = PositioningStrategies.projectionPosition();
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.CONST_KEYWORD, "CONST_KEYWORD");
        CONST_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.FUN_KEYWORD, "FUN_KEYWORD");
        FUN_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.SUSPEND_KEYWORD, "SUSPEND_KEYWORD");
        SUSPEND_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.DATA_KEYWORD, "DATA_KEYWORD");
        DATA_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.OPERATOR_KEYWORD, "OPERATOR_KEYWORD");
        OPERATOR_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.ENUM_KEYWORD, "ENUM_KEYWORD");
        ENUM_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.TAILREC_KEYWORD, "TAILREC_KEYWORD");
        TAILREC_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        OBJECT_KEYWORD = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtObjectDeclaration element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element.getObjectKeyword();
                if (psiElement == null) {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        FIELD_KEYWORD = new DeclarationHeader<KtBackingField>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBackingField element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element.getFieldKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "element.fieldKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PROPERTY_DELEGATE = new DeclarationHeader<KtProperty>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtProperty element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtPropertyDelegate delegate = element.getDelegate();
                return delegate != null ? PositioningStrategyKt.markElement(delegate) : PositioningStrategies.DEFAULT.mark(element);
            }
        };
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof KtNamedDeclaration) {
                    psiElement = ((KtNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement2 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element).getPackageDirective();
                    Intrinsics.checkNotNull(ktPackageDirective);
                    psiElement = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = null;
                }
                if (nameIdentifier == null && element instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                PsiElement psiElement3 = nameIdentifier;
                if (psiElement3 == null) {
                    psiElement3 = element;
                }
                return PositioningStrategyKt.markElement(psiElement3);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReferenceExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtArrayAccessExpression) {
                    List<TextRange> list2 = ((KtArrayAccessExpression)element).getBracketRanges();
                    Intrinsics.checkNotNullExpressionValue(list2, "element.bracketRanges");
                    List<TextRange> ranges = list2;
                    if (!ranges.isEmpty()) {
                        return ranges;
                    }
                }
                return CollectionsKt.listOf(element.getTextRange());
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtArrayAccessExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtContainerNode ktContainerNode = element.getIndicesNode();
                Intrinsics.checkNotNullExpressionValue(ktContainerNode, "element.indicesNode");
                return PositioningStrategyKt.markElement(ktContainerNode);
            }
        };
        SAFE_ACCESS = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                ASTNode aSTNode = element.getNode().findChildByType(KtTokens.SAFE_ACCESS);
                PsiElement psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                if (psiElement == null) {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        TokenSet tokenSet3 = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue(tokenSet3, "VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedPositioningStrategy(tokenSet3);
        TokenSet tokenSet4 = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue(tokenSet4, "MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedPositioningStrategy(tokenSet4);
        iElementTypeArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue(KtTokens.INLINE_KEYWORD, "INLINE_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.VALUE_KEYWORD, "VALUE_KEYWORD");
        INLINE_OR_VALUE_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.INNER_KEYWORD, "INNER_KEYWORD");
        INNER_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        iElementTypeArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue(KtTokens.NOINLINE_KEYWORD, "NOINLINE_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.CROSSINLINE_KEYWORD, "CROSSINLINE_KEYWORD");
        INLINE_PARAMETER_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        INLINE_FUN_MODIFIER = new InlineFunPositioningStrategy();
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeProjection element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element.getProjectionToken();
                Intrinsics.checkNotNull(psiElement);
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtExpression ktExpression = element.getDefaultValue();
                Intrinsics.checkNotNull(ktExpression);
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "element.defaultValue!!.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        PARAMETER_VARARG_MODIFIER = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtModifierList ktModifierList = element.getModifierList();
                Intrinsics.checkNotNull(ktModifierList);
                PsiElement psiElement = ktModifierList.getModifier(KtTokens.VARARG_KEYWORD);
                Intrinsics.checkNotNull(psiElement);
                PsiElement varargModifier = psiElement;
                ASTNode aSTNode = varargModifier.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "varargModifier.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        NAME_OF_NAMED_ARGUMENT = new PositioningStrategy<KtValueArgument>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtValueArgument element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtValueArgumentName ktValueArgumentName = element.getArgumentName();
                return PositioningStrategyKt.markElement(ktValueArgumentName == null ? (KtElementImplStub)element : (KtElementImplStub)ktValueArgumentName);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtCallElement ktCallElement = element instanceof KtCallElement ? (KtCallElement)element : null;
                KtExpression ktExpression = ktCallElement != null ? ktCallElement.getCalleeExpression() : null;
                return PositioningStrategyKt.markElement(ktExpression == null ? element : (PsiElement)ktExpression);
            }
        };
        CALL_ELEMENT_WITH_DOT = new PositioningStrategy<KtQualifiedExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtQualifiedExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                List<TextRange> callElementRanges = PositioningStrategies.INSTANCE.getSELECTOR_BY_QUALIFIED().mark(element);
                if (callElementRanges.size() != 1) {
                    return callElementRanges;
                }
                TextRange callElementRange = CollectionsKt.first(callElementRanges);
                List<TextRange> dotRanges = PositioningStrategies.SAFE_ACCESS.mark(element);
                if (dotRanges.size() != 1) {
                    return dotRanges;
                }
                TextRange dotRange = CollectionsKt.first(dotRanges);
                return CollectionsKt.listOf(new TextRange(dotRange.getStartOffset(), callElementRange.getEndOffset()));
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
                TextRange lastBracketRange = ktBlockExpression != null ? ktBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (!super.isValid((PsiElement)element)) return false;
                KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
                if (ktBlockExpression == null) return false;
                TextRange textRange2 = ktBlockExpression.getLastBracketRange();
                if (textRange2 == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element, "element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtParameter) {
                    PsiElement psiElement = ((KtParameter)element).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
                    PsiElement psiElement = ((KtDestructuringDeclaration)element).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else {
                    throw new IllegalStateException(("Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element)).toString());
                }
                return list2;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenEntry element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element.getElseKeyword();
                Intrinsics.checkNotNull(psiElement);
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element.getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "element.whenKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        IF_EXPRESSION = new PositioningStrategy<KtIfExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtIfExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element.getIfKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "element.ifKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenConditionInRange element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "element.operationReference");
                return PositioningStrategyKt.markElement(ktOperationReferenceExpression);
            }
        };
        SPECIAL_CONSTRUCT_TOKEN = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element, "element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtWhenExpression) {
                    PsiElement psiElement = ((KtWhenExpression)element).getWhenKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "element.whenKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtIfExpression) {
                    PsiElement psiElement = ((KtIfExpression)element).getIfKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "element.ifKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtOperationExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "element.operationReference");
                    list2 = PositioningStrategyKt.markElement(ktSimpleNameExpression);
                } else {
                    throw new IllegalStateException(("Expression is not an if, when or operation expression: " + PsiUtilsKt.getElementTextWithContext(element)).toString());
                }
                return list2;
            }
        };
        REDUNDANT_NULLABLE = new PositioningStrategy<KtTypeReference>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeReference element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtTypeElement typeElement = element.getTypeElement();
                ASTNode question = null;
                ASTNode prevQuestion = null;
                ASTNode lastQuestion = null;
                while (typeElement instanceof KtNullableType) {
                    prevQuestion = question;
                    question = ((KtNullableType)typeElement).getQuestionMarkNode();
                    if (lastQuestion == null) {
                        lastQuestion = question;
                    }
                    typeElement = ((KtNullableType)typeElement).getInnerType();
                }
                if (lastQuestion != null) {
                    ASTNode aSTNode = prevQuestion;
                    if (aSTNode == null) {
                        aSTNode = lastQuestion;
                    }
                    PsiElement psiElement = aSTNode.getPsi();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "prevQuestion ?: lastQuestion).psi");
                    PsiElement psiElement2 = lastQuestion.getPsi();
                    Intrinsics.checkNotNullExpressionValue(psiElement2, "lastQuestion.psi");
                    return PositioningStrategyKt.markRange(psiElement, psiElement2);
                }
                return super.mark((PsiElement)element);
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNullableType element) {
                Intrinsics.checkNotNullParameter(element, "element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "element.questionMarkNode");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        QUESTION_MARK_BY_TYPE = new PositioningStrategy<KtTypeReference>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeReference element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtTypeElement typeElement = element.getTypeElement();
                if (typeElement instanceof KtNullableType) {
                    ASTNode aSTNode = ((KtNullableType)typeElement).getQuestionMarkNode();
                    Intrinsics.checkNotNullExpressionValue(aSTNode, "typeElement.questionMarkNode");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return super.mark((PsiElement)element);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtCallExpression) {
                    KtElement ktElement;
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element).getTypeArgumentList();
                    if (ktTypeArgumentList != null) {
                        ktElement = ktTypeArgumentList;
                    } else {
                        KtExpression ktExpression = ((KtCallExpression)element).getCalleeExpression();
                        ktElement = ktExpression != null ? (KtElement)ktExpression : (KtElement)element;
                    }
                    return PositioningStrategyKt.markRange(element, ktElement);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                List<TextRange> list2;
                boolean $i$f$getChildOfType;
                PsiElement $this$getChildOfType$iv;
                KtValueArgumentList ktValueArgumentList;
                KtElement qualifiedAccess;
                KtElement ktElement;
                KtElement left;
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken())) {
                    left = ((KtBinaryExpression)element).getLeft();
                    boolean bl = false;
                    PsiElement psiElement = PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations(left);
                    if (psiElement != null) {
                        PsiElement it = psiElement;
                        boolean bl2 = false;
                        return PositioningStrategyKt.markElement(it);
                    }
                }
                if ((left = element) instanceof KtQualifiedExpression) {
                    KtExpression ktExpression = ((KtQualifiedExpression)element).getSelectorExpression();
                    if (ktExpression == null) {
                        ktExpression = (KtExpression)element;
                    }
                    ktElement = ktExpression;
                } else if (left instanceof KtClassOrObject) {
                    KtSuperTypeList ktSuperTypeList = ((KtClassOrObject)element).getSuperTypeList();
                    ktElement = ktSuperTypeList != null ? (KtElementImplStub)ktSuperTypeList : (KtElementImplStub)element;
                } else {
                    ktElement = qualifiedAccess = element;
                }
                if ((ktValueArgumentList = qualifiedAccess instanceof KtValueArgumentList ? (KtValueArgumentList)qualifiedAccess : null) == null) {
                    $this$getChildOfType$iv = qualifiedAccess;
                    $i$f$getChildOfType = false;
                    ktValueArgumentList = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtValueArgumentList.class);
                }
                KtValueArgumentList argumentList2 = ktValueArgumentList;
                if (argumentList2 != null) {
                    Object object;
                    PsiElement rightParenthesis;
                    block15: {
                        PsiElement psiElement = argumentList2.getRightParenthesis();
                        if (psiElement == null) {
                            return PositioningStrategyKt.markElement(qualifiedAccess);
                        }
                        rightParenthesis = psiElement;
                        PsiElement[] psiElementArray = argumentList2.getChildren();
                        Intrinsics.checkNotNullExpressionValue(psiElementArray, "argumentList.children");
                        Object[] objectArray = psiElementArray;
                        int n = objectArray.length + -1;
                        if (0 <= n) {
                            do {
                                int n2 = n--;
                                Object object2 = objectArray[n2];
                                PsiElement it = (PsiElement)object2;
                                boolean bl = false;
                                if (!(it instanceof KtValueArgument)) continue;
                                object = object2;
                                break block15;
                            } while (0 <= n);
                        }
                        object = null;
                    }
                    PsiElement lastArgument = (PsiElement)object;
                    list2 = lastArgument != null ? PositioningStrategyKt.markRange(lastArgument, rightParenthesis) : PositioningStrategyKt.markRange(qualifiedAccess, rightParenthesis);
                } else if (qualifiedAccess instanceof KtCallExpression) {
                    $this$getChildOfType$iv = qualifiedAccess;
                    $i$f$getChildOfType = false;
                    KtNameReferenceExpression ktNameReferenceExpression = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtNameReferenceExpression.class);
                    list2 = PositioningStrategyKt.markElement(ktNameReferenceExpression != null ? (NavigatablePsiElement)ktNameReferenceExpression : (NavigatablePsiElement)qualifiedAccess);
                } else {
                    list2 = PositioningStrategyKt.markElement(qualifiedAccess);
                }
                return list2;
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtFunction element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkNotNullExpressionValue(aSTNode, "element.lBrace.node");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = element.getTextRange();
                    TextRange textRange2 = TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1);
                    Intrinsics.checkNotNullExpressionValue(textRange2, "create(elementTextRange.\u2026tTextRange.endOffset - 1)");
                    return CollectionsKt.listOf(textRange2);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    TextRange textRange2 = TextRange.create(endOffset - 1, endOffset);
                    Intrinsics.checkNotNullExpressionValue(textRange2, "create(endOffset - 1, endOffset)");
                    return CollectionsKt.listOf(textRange2);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtSimpleNameExpression ktSimpleNameExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "element.operationReference");
                return PositioningStrategyKt.markRange(ktSimpleNameExpression, element);
            }
        };
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.COMPANION_KEYWORD, "COMPANION_KEYWORD");
        COMPANION_OBJECT = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element;
                if (psiElement instanceof KtSecondaryConstructor) {
                    KtParameterList ktParameterList = ((KtSecondaryConstructor)element).getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement2 = ((KtSecondaryConstructor)element).getConstructorKeyword();
                    PsiElement psiElement3 = valueParameterList.getLastChild();
                    Intrinsics.checkNotNullExpressionValue(psiElement3, "valueParameterList.lastChild");
                    list2 = PositioningStrategyKt.markRange(psiElement2, psiElement3);
                } else if (psiElement instanceof KtConstructorDelegationCall) {
                    if (((KtConstructorDelegationCall)element).isImplicit()) {
                        PsiElement $this$getStrictParentOfType$iv = element;
                        boolean $i$f$getStrictParentOfType = false;
                        KtSecondaryConstructor ktSecondaryConstructor = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtSecondaryConstructor.class, true);
                        Intrinsics.checkNotNull(ktSecondaryConstructor);
                        KtSecondaryConstructor constructor = ktSecondaryConstructor;
                        KtParameterList ktParameterList = constructor.getValueParameterList();
                        if (ktParameterList == null) {
                            return PositioningStrategyKt.markElement(constructor);
                        }
                        KtParameterList valueParameterList = ktParameterList;
                        PsiElement psiElement4 = constructor.getConstructorKeyword();
                        PsiElement psiElement5 = valueParameterList.getLastChild();
                        Intrinsics.checkNotNullExpressionValue(psiElement5, "valueParameterList.lastChild");
                        return PositioningStrategyKt.markRange(psiElement4, psiElement5);
                    }
                    KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                    list2 = PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression == null ? (KtElementImpl)element : (KtElementImpl)ktConstructorDelegationReferenceExpression);
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtEnumEntry element) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkNotNullParameter(element, "element");
                List<KtSuperTypeListEntry> list2 = element.getSuperTypeListEntries();
                Intrinsics.checkNotNullExpressionValue(list2, "element.superTypeListEntries");
                List<KtSuperTypeListEntry> specifiers = list2;
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element;
                } else {
                    KtSuperTypeListEntry ktSuperTypeListEntry = specifiers.get(0);
                    Intrinsics.checkNotNullExpressionValue(ktSuperTypeListEntry, "specifiers[0]");
                    ktElementImplStub = ktSuperTypeListEntry;
                }
                return PositioningStrategyKt.markElement(ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtExpression ktExpression = element.getLeft();
                Intrinsics.checkNotNull(ktExpression);
                int n = PsiUtilsKt.getStartOffset(ktExpression);
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "element.operationReference");
                return CollectionsKt.listOf(new TextRange(n, PsiUtilsKt.getEndOffset(ktOperationReferenceExpression)));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "element.operationReference");
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(ktOperationReferenceExpression), PsiUtilsKt.getEndOffset(element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtImportDirective element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element, "element");
                KtElement ktElement = element.getAlias();
                if (ktElement != null && (psiElement = ktElement.getNameIdentifier()) != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                ktElement = element.getImportedReference();
                if (ktElement != null) {
                    KtElement it = ktElement;
                    boolean bl = false;
                    if (it instanceof KtQualifiedExpression) {
                        KtExpression ktExpression = ((KtQualifiedExpression)it).getSelectorExpression();
                        if (ktExpression != null) {
                            KtExpression it2 = ktExpression;
                            boolean bl2 = false;
                            return PositioningStrategyKt.markElement(it2);
                        }
                    }
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        RETURN_WITH_LABEL = new PositioningStrategy<KtReturnExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReturnExpression element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement labeledExpression = element.getLabeledExpression();
                if (labeledExpression != null) {
                    return PositioningStrategyKt.markRange(element, labeledExpression);
                }
                PsiElement psiElement = element.getReturnKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "element.returnKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        RECEIVER = new DeclarationHeader<KtCallableDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtCallableDeclaration element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtTypeReference ktTypeReference = element.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference it = ktTypeReference;
                    boolean bl = false;
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        OPERATOR = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element, "element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtBinaryExpression) {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "element.operationReference");
                    list2 = this.mark(ktOperationReferenceExpression);
                } else if (ktExpression instanceof KtBinaryExpressionWithTypeRHS) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpressionWithTypeRHS)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "element.operationReference");
                    list2 = this.mark(ktSimpleNameExpression);
                } else if (ktExpression instanceof KtUnaryExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtUnaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "element.operationReference");
                    list2 = this.mark(ktSimpleNameExpression);
                } else {
                    list2 = super.mark((PsiElement)element);
                }
                return list2;
            }
        };
        DOT_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken())) {
                    KtExpression ktExpression = ((KtBinaryExpression)element).getLeft();
                    if (ktExpression != null) {
                        KtExpression left = ktExpression;
                        boolean bl = false;
                        PsiElement $this$findDescendantOfType_u24default$iv = left;
                        Function1 predicate$iv = DOT_BY_QUALIFIED$1$mark$lambda$1$$inlined$findDescendantOfType$default$1.INSTANCE;
                        boolean $i$f$findDescendantOfType = false;
                        PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        Ref.ObjectRef<T> result$iv$iv = new Ref.ObjectRef<T>();
                        $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(@NotNull PsiElement element) {
                                Intrinsics.checkNotNullParameter(element, "element");
                                if (element instanceof KtDotQualifiedExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                                    this.$result.element = element;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                            }
                        });
                        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)result$iv$iv.element);
                        if (ktDotQualifiedExpression != null) {
                            KtDotQualifiedExpression it = ktDotQualifiedExpression;
                            boolean bl2 = false;
                            return this.mark(it);
                        }
                    }
                }
                if (element instanceof KtDotQualifiedExpression) {
                    PsiElement psiElement = ((KtDotQualifiedExpression)element).getOperationTokenNode().getPsi();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "element.operationTokenNode.psi");
                    return this.mark(psiElement);
                }
                return PositioningStrategies.INSTANCE.getREFERENCE_BY_QUALIFIED().mark(element);
            }
        };
        SELECTOR_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement psiElement;
                KtExpression selectorExpression;
                KtElement ktElement;
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken()) && (ktElement = ((KtBinaryExpression)element).getLeft()) != null) {
                    KtElement it = ktElement;
                    boolean bl = false;
                    return this.mark(it);
                }
                if (element instanceof KtQualifiedExpression && (selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression()) instanceof KtElement) {
                    return this.mark(selectorExpression);
                }
                if (element instanceof KtImportDirective) {
                    ktElement = ((KtImportDirective)element).getAlias();
                    if (ktElement != null && (psiElement = ((KtImportAlias)ktElement).getNameIdentifier()) != null) {
                        PsiElement it = psiElement;
                        boolean bl = false;
                        return this.mark(it);
                    }
                    ktElement = ((KtImportDirective)element).getImportedReference();
                    if (ktElement != null) {
                        KtElement it = ktElement;
                        boolean bl = false;
                        return this.mark(it);
                    }
                }
                if (element instanceof KtTypeReference && (ktElement = ((KtTypeReference)element).getTypeElement()) != null && (psiElement = PositioningStrategies.access$getReferencedTypeExpression(PositioningStrategies.INSTANCE, (KtTypeElement)ktElement)) != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return this.mark(it);
                }
                return super.mark(element);
            }
        };
        NAME_IDENTIFIER = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof PsiNameIdentifierOwner) {
                    PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                    if (nameIdentifier != null) {
                        return super.mark(nameIdentifier);
                    }
                } else {
                    PsiElement nameIdentifier;
                    if (element instanceof KtLabelReferenceExpression) {
                        return super.mark(((KtLabelReferenceExpression)element).getReferencedNameElement());
                    }
                    if (element instanceof KtPackageDirective && (nameIdentifier = ((KtPackageDirective)element).getNameIdentifier()) != null) {
                        return super.mark(nameIdentifier);
                    }
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        SPREAD_OPERATOR = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(element, "element");
                UserDataHolder userDataHolder = element instanceof KtValueArgument ? (KtValueArgument)element : null;
                if ((userDataHolder != null && (userDataHolder = ((KtValueArgument)userDataHolder).getSpreadElement()) != null && (userDataHolder = ((LeafPsiElement)userDataHolder).getNode()) != null ? userDataHolder.getPsi() : (psiElement = null)) == null) {
                    psiElement = element;
                }
                return super.mark(psiElement);
            }
        };
        FUN_INTERFACE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element, "element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClass) {
                    list2 = PositioningStrategies.FUN_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    KtTypeParameterList typeParameterList = ((KtNamedFunction)element).getTypeParameterList();
                    KtTypeParameterList ktTypeParameterList = typeParameterList;
                    if (ktTypeParameterList != null) {
                        list2 = PositioningStrategyKt.markElement(ktTypeParameterList);
                    } else if (element.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                        list2 = PositioningStrategies.SUSPEND_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                    } else {
                        PsiElement psiElement = ((KtNamedFunction)element).getFunKeyword();
                        if (psiElement == null) {
                            psiElement = element;
                        }
                        list2 = PositioningStrategyKt.markElement(psiElement);
                    }
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        REFERENCE_BY_QUALIFIED = new FindReferencePositioningStrategy(false);
        REFERENCED_NAME_BY_QUALIFIED = new FindReferencePositioningStrategy(true);
        iElementTypeArray2 = new IElementType[1];
        Intrinsics.checkNotNullExpressionValue(KtTokens.REIFIED_KEYWORD, "REIFIED_KEYWORD");
        REIFIED_MODIFIER = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        PROPERTY_INITIALIZER = new PositioningStrategy<KtProperty>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtProperty element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtExpression ktExpression = element.getInitializer();
                if (ktExpression == null) {
                    ktExpression = element;
                }
                return PositioningStrategyKt.markElement(ktExpression);
            }
        };
        WHOLE_ELEMENT = new PositioningStrategy<KtElement>(){};
        TYPE_PARAMETERS_LIST = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtTypeParameterListOwner) {
                    KtTypeParameterList ktTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList();
                    return PositioningStrategyKt.markElement(ktTypeParameterList == null ? (KtElement)element : (KtElement)ktTypeParameterList);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        ANNOTATION_USE_SITE = new PositioningStrategy<KtAnnotationEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtAnnotationEntry element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = element.getUseSiteTarget();
                return PositioningStrategyKt.markElement(ktAnnotationUseSiteTarget == null ? (KtElementImplStub)element : (KtElementImplStub)ktAnnotationUseSiteTarget);
            }
        };
        IMPORT_LAST_NAME = new PositioningStrategy<PsiElement>(){

            public boolean isValid(@NotNull PsiElement element) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof PsiErrorElement) {
                        return false;
                    }
                    PsiElement[] psiElementArray = element.getChildren();
                    Intrinsics.checkNotNullExpressionValue(psiElementArray, "element.children");
                    Object[] $this$any$iv = psiElementArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue(it, "it");
                        if (!(!this.isValid(it))) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return !bl;
            }

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtImportDirective) {
                    KtExpression ktExpression;
                    KtExpression importedReference = ((KtImportDirective)element).getImportedReference();
                    if (importedReference instanceof KtDotQualifiedExpression && (ktExpression = ((KtDotQualifiedExpression)importedReference).getSelectorExpression()) != null) {
                        KtExpression it = ktExpression;
                        boolean bl = false;
                        return super.mark((PsiElement)it);
                    }
                    KtExpression ktExpression2 = ((KtImportDirective)element).getImportedReference();
                    return super.mark((PsiElement)(ktExpression2 == null ? (KtElement)element : (KtElement)ktExpression2));
                }
                return super.mark(element);
            }
        };
        LABEL = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                KtElementImpl ktElementImpl = element instanceof KtExpressionWithLabel ? (KtExpressionWithLabel)element : null;
                return super.mark((PsiElement)(ktElementImpl != null && (ktElementImpl = ktElementImpl.getLabelQualifier()) != null ? (KtElement)ktElementImpl : element));
            }
        };
        COMMAS = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(element, "element");
                List<TextRange> $this$mark_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                Iterator<PsiElement> iterator2 = PsiUtilsKt.getAllChildren(element).iterator();
                while (iterator2.hasNext()) {
                    PsiElement child = iterator2.next();
                    if (!Intrinsics.areEqual(child.getNode().getElementType(), KtTokens.COMMA)) continue;
                    $this$mark_u24lambda_u240.add(PositioningStrategyKt.markSingleElement(child));
                }
                return CollectionsKt.build(list2);
            }
        };
        iElementTypeArray2 = new IElementType[3];
        Intrinsics.checkNotNullExpressionValue(KtTokens.ABSTRACT_KEYWORD, "ABSTRACT_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.OPEN_KEYWORD, "OPEN_KEYWORD");
        Intrinsics.checkNotNullExpressionValue(KtTokens.SEALED_KEYWORD, "SEALED_KEYWORD");
        NON_FINAL_MODIFIER_OR_NAME = new ModifierSetBasedPositioningStrategy(iElementTypeArray2);
        DELEGATED_SUPERTYPE_BY_KEYWORD = new PositioningStrategy<KtTypeReference>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeReference element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement psiElement = element.getParent();
                KtDelegatedSuperTypeEntry ktDelegatedSuperTypeEntry = psiElement instanceof KtDelegatedSuperTypeEntry ? (KtDelegatedSuperTypeEntry)psiElement : null;
                if (ktDelegatedSuperTypeEntry == null) {
                    return super.mark((PsiElement)element);
                }
                KtDelegatedSuperTypeEntry parent2 = ktDelegatedSuperTypeEntry;
                PsiElement psiElement2 = parent2.getByKeywordNode().getPsi();
                if (psiElement2 == null) {
                    psiElement2 = element;
                }
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "frontend.common-psi"})
    public static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkNotNullParameter(element, "element");
            if (element instanceof KtNamedDeclaration && !(element instanceof KtObjectDeclaration) && !(element instanceof KtSecondaryConstructor) && !(element instanceof KtFunction) && ((KtNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "locateReferencedName", "", "(Z)V", "getLocateReferencedName", "()Z", "mark", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "element", "frontend.common-psi"})
    @SourceDebugExtension(value={"SMAP\nPositioningStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1041:1\n1#2:1042\n*E\n"})
    public static final class FindReferencePositioningStrategy
    extends PositioningStrategy<PsiElement> {
        private final boolean locateReferencedName;

        public FindReferencePositioningStrategy(boolean locateReferencedName) {
            this.locateReferencedName = locateReferencedName;
        }

        public final boolean getLocateReferencedName() {
            return this.locateReferencedName;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            PsiElement result2;
            PsiElement psiElement;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter(element, "element");
            if (element instanceof KtBinaryExpression && Intrinsics.areEqual(((KtBinaryExpression)element).getOperationToken(), KtTokens.EQ) && (ktExpression = ((KtBinaryExpression)element).getLeft()) != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                return this.mark(it);
            }
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof KtQualifiedExpression) {
                KtExpression ktExpression2;
                KtExpression selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression();
                if (selectorExpression instanceof KtCallExpression) {
                    ktExpression2 = ((KtCallExpression)selectorExpression).getCalleeExpression();
                    if (ktExpression2 == null) {
                        ktExpression2 = selectorExpression;
                    }
                } else {
                    ktExpression2 = selectorExpression instanceof KtReferenceExpression ? selectorExpression : (KtExpression)element;
                }
                psiElement = ktExpression2;
            } else if (psiElement2 instanceof KtCallableReferenceExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtCallableReferenceExpression)element).getCallableReference();
                Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "element.callableReference");
                psiElement = ktSimpleNameExpression;
            } else if (psiElement2 instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element).getCalleeExpression();
                if (ktExpression3 == null) {
                    ktExpression3 = (KtExpression)element;
                }
                psiElement = ktExpression3;
            } else if (psiElement2 instanceof KtConstructorDelegationCall) {
                KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                psiElement = ktConstructorDelegationReferenceExpression == null ? (KtElementImpl)element : (KtElementImpl)ktConstructorDelegationReferenceExpression;
            } else if (psiElement2 instanceof KtSuperTypeCallEntry) {
                KtConstructorCalleeExpression ktConstructorCalleeExpression = ((KtSuperTypeCallEntry)element).getCalleeExpression();
                Intrinsics.checkNotNullExpressionValue(ktConstructorCalleeExpression, "element.calleeExpression");
                psiElement = ktConstructorCalleeExpression;
            } else if (psiElement2 instanceof KtOperationExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "element.operationReference");
                psiElement = ktSimpleNameExpression;
            } else if (psiElement2 instanceof KtWhenConditionInRange) {
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtWhenConditionInRange)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "element.operationReference");
                psiElement = ktOperationReferenceExpression;
            } else if (psiElement2 instanceof KtAnnotationEntry) {
                KtConstructorCalleeExpression ktConstructorCalleeExpression = ((KtAnnotationEntry)element).getCalleeExpression();
                psiElement = ktConstructorCalleeExpression == null ? (KtElementImplStub)element : (KtElementImplStub)ktConstructorCalleeExpression;
            } else if (psiElement2 instanceof KtTypeReference) {
                KtTypeElement ktTypeElement = ((KtTypeReference)element).getTypeElement();
                KtNullableType ktNullableType = ktTypeElement instanceof KtNullableType ? (KtNullableType)ktTypeElement : null;
                KtTypeElement ktTypeElement2 = ktNullableType != null ? ktNullableType.getInnerType() : null;
                psiElement = ktTypeElement2 == null ? (KtElement)element : (KtElement)ktTypeElement2;
            } else if (psiElement2 instanceof KtImportDirective) {
                KtExpression ktExpression4 = ((KtImportDirective)element).getImportedReference();
                psiElement = ktExpression4 == null ? (KtElement)element : (KtElement)ktExpression4;
            } else {
                psiElement = result2 = element;
            }
            while (this.locateReferencedName && result2 instanceof KtParenthesizedExpression) {
                KtExpression ktExpression5 = ((KtParenthesizedExpression)result2).getExpression();
                if (ktExpression5 == null) break;
                result2 = ktExpression5;
            }
            return super.mark(result2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$InlineFunPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "()V", "mark", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "frontend.common-psi"})
    private static final class InlineFunPositioningStrategy
    extends ModifierSetBasedPositioningStrategy {
        public InlineFunPositioningStrategy() {
            IElementType[] iElementTypeArray = new IElementType[1];
            Intrinsics.checkNotNullExpressionValue(KtTokens.INLINE_KEYWORD, "INLINE_KEYWORD");
            super(iElementTypeArray);
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element) {
            Intrinsics.checkNotNullParameter(element, "element");
            if (element instanceof KtProperty) {
                List<TextRange> list2 = this.markModifier(((KtProperty)element).getGetter());
                if (list2 == null && (list2 = this.markModifier(((KtProperty)element).getSetter())) == null) {
                    list2 = super.mark(element);
                }
                return list2;
            }
            return super.mark(element);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "tokens", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "([Lcom/intellij/psi/tree/IElementType;)V", "modifierSet", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "mark", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "element", "markModifier", "frontend.common-psi"})
    @SourceDebugExtension(value={"SMAP\nPositioningStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1041:1\n11383#2,9:1042\n13309#2:1051\n13310#2:1053\n11392#2:1054\n1#3:1052\n1#3:1055\n*S KotlinDebug\n*F\n+ 1 PositioningStrategies.kt\norg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy\n*L\n419#1:1042,9\n419#1:1051\n419#1:1053\n419#1:1054\n419#1:1052\n*E\n"})
    private static class ModifierSetBasedPositioningStrategy
    extends PositioningStrategy<KtModifierListOwner> {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedPositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter(modifierSet, "modifierSet");
            this.modifierSet = modifierSet;
        }

        public ModifierSetBasedPositioningStrategy(IElementType ... tokens) {
            Intrinsics.checkNotNullParameter(tokens, "tokens");
            TokenSet tokenSet = TokenSet.create(Arrays.copyOf(tokens, tokens.length));
            Intrinsics.checkNotNullExpressionValue(tokenSet, "create(*tokens)");
            this(tokenSet);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        protected final List<TextRange> markModifier(@Nullable KtModifierListOwner element) {
            v0 = this.modifierSet.getTypes();
            Intrinsics.checkNotNullExpressionValue(v0, "modifierSet.types");
            $this$mapNotNull$iv = v0;
            $i$f$mapNotNull = false;
            var4_5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var10_12 = ((void)$this$forEach$iv$iv$iv).length;
            for (var9_11 = 0; var9_11 < var10_12; ++var9_11) {
                element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var9_11];
                $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                it = (IElementType)element$iv$iv;
                $i$a$-mapNotNull-PositioningStrategies$ModifierSetBasedPositioningStrategy$markModifier$1 = false;
                v1 = element;
                if (v1 == null || (v1 = v1.getModifierList()) == null) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                if ((v1 = v1.getModifier((KtModifierKeywordToken)it)) != null) {
                    v2 = v1.getTextRange();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                if (v2 == null) continue;
                it$iv$iv = v2;
                $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            it = var2_2 = (List<E>)destination$iv$iv;
            $i$a$-takeIf-PositioningStrategies$ModifierSetBasedPositioningStrategy$markModifier$2 = false;
            return !((Collection)it).isEmpty() != false ? var2_2 : null;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element) {
            PsiElement psiElement;
            PsiElement nameIdentifier;
            List<TextRange> result2;
            Intrinsics.checkNotNullParameter(element, "element");
            List<TextRange> list2 = result2 = this.markModifier(element);
            if (list2 != null) {
                return list2;
            }
            if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                return PositioningStrategyKt.markElement(nameIdentifier);
            }
            KtModifierListOwner ktModifierListOwner = element;
            if (ktModifierListOwner instanceof KtObjectDeclaration) {
                PsiElement psiElement2 = ((KtObjectDeclaration)element).getObjectKeyword();
                psiElement = psiElement2;
                Intrinsics.checkNotNull(psiElement2);
            } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                PsiElement psiElement3 = ((KtPropertyAccessor)element).getNamePlaceholder();
                psiElement = psiElement3;
                Intrinsics.checkNotNullExpressionValue(psiElement3, "element.namePlaceholder");
            } else if (ktModifierListOwner instanceof KtAnonymousInitializer) {
                psiElement = element;
            } else {
                throw new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + '\'');
            }
            PsiElement elementToMark = psiElement;
            return PositioningStrategyKt.markElement(elementToMark);
        }
    }
}

