/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.VersionSpecificBehaviorKt;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BinaryModuleData;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "", "version", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "moduleData", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "debugName", "(Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;Ljava/util/Map;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;Ljava/lang/String;)V", "getModuleData", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "getPackageFqName2Parts", "()Ljava/util/Map;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "findPackageParts", "packageFqName", "toString", "Companion", "metadata.jvm"})
public final class ModuleMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmMetadataVersion version;
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    @NotNull
    private final String debugName;
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY = new ModuleMapping(JvmMetadataVersion.INSTANCE, MapsKt.emptyMap(), org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "EMPTY");
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED = new ModuleMapping(JvmMetadataVersion.INSTANCE, MapsKt.emptyMap(), org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "CORRUPTED");
    public static final int STRICT_METADATA_VERSION_SEMANTICS_FLAG = 1;

    private ModuleMapping(JvmMetadataVersion version, Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData2, String debugName) {
        this.version = version;
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData2;
        this.debugName = debugName;
    }

    @NotNull
    public final JvmMetadataVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    @NotNull
    public final BinaryModuleData getModuleData() {
        return this.moduleData;
    }

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    public /* synthetic */ ModuleMapping(JvmMetadataVersion version, Map packageFqName2Parts, BinaryModuleData moduleData2, String debugName, DefaultConstructorMarker $constructor_marker) {
        this(version, packageFqName2Parts, moduleData2, debugName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002JF\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016J6\u0010\u0018\u001a\u0004\u0018\u00010\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping$Companion;", "", "()V", "CORRUPTED", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "EMPTY", "MAPPING_FILE_EXT", "", "STRICT_METADATA_VERSION_SEMANTICS_FLAG", "", "emptyBinaryData", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "loadModuleMapping", "bytes", "", "debugName", "skipMetadataVersionCheck", "", "isJvmPackageNameSupported", "metadataVersionFromLanguageVersion", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "reportIncompatibleVersionError", "Lkotlin/Function1;", "", "loadMultiFileFacadeInternalName", "multifileFacadeIds", "", "multifileFacadeShortNames", "index", "packageFqName", "readVersionNumber", "", "stream", "Ljava/io/DataInputStream;", "metadata.jvm"})
    @SourceDebugExtension(value={"SMAP\nModuleMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapping.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n1#2:303\n372#3,7:304\n372#3,7:311\n1855#4,2:318\n1549#4:320\n1620#4,3:321\n*S KotlinDebug\n*F\n+ 1 ModuleMapping.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping$Companion\n*L\n88#1:304,7\n120#1:311,7\n121#1:318,2\n126#1:320\n126#1:321,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final int[] readVersionNumber(@NotNull DataInputStream stream) {
            int[] nArray;
            Intrinsics.checkNotNullParameter(stream, "stream");
            try {
                int[] nArray2;
                int size = stream.readInt();
                if (size < 0 || size > 1024) {
                    nArray2 = null;
                } else {
                    int n = 0;
                    int[] nArray3 = new int[size];
                    while (n < size) {
                        int n2 = n++;
                        nArray3[n2] = stream.readInt();
                    }
                    nArray2 = nArray3;
                }
                nArray = nArray2;
            }
            catch (IOException e) {
                nArray = null;
            }
            return nArray;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes, @NotNull String debugName, boolean skipMetadataVersionCheck2, boolean isJvmPackageNameSupported, @NotNull JvmMetadataVersion metadataVersionFromLanguageVersion, @NotNull Function1<? super JvmMetadataVersion, Unit> reportIncompatibleVersionError) {
            void $this$mapTo$iv$iv;
            ProtoBuf.Annotation jvmPackageName;
            Object packageParts2;
            ExtensionRegistryLite extensionRegistryLite;
            Intrinsics.checkNotNullParameter(debugName, "debugName");
            Intrinsics.checkNotNullParameter(metadataVersionFromLanguageVersion, "metadataVersionFromLanguageVersion");
            Intrinsics.checkNotNullParameter(reportIncompatibleVersionError, "reportIncompatibleVersionError");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            int[] nArray = this.readVersionNumber(stream);
            if (nArray == null) {
                return CORRUPTED;
            }
            int[] versionNumber = nArray;
            JvmMetadataVersion preVersion = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (!skipMetadataVersionCheck2 && !preVersion.isCompatible(metadataVersionFromLanguageVersion)) {
                reportIncompatibleVersionError.invoke(preVersion);
                return EMPTY;
            }
            int flags = VersionSpecificBehaviorKt.isKotlin1Dot4OrLater(preVersion) ? stream.readInt() : 0;
            JvmMetadataVersion version = new JvmMetadataVersion(versionNumber, (flags & 1) != 0);
            if (!skipMetadataVersionCheck2 && !version.isCompatible(metadataVersionFromLanguageVersion)) {
                reportIncompatibleVersionError.invoke(version);
                return EMPTY;
            }
            ExtensionRegistryLite p0 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
            boolean bl = false;
            BuiltInsProtoBuf.registerAllExtensions(p0);
            ExtensionRegistryLite extensions = extensionRegistryLite;
            JvmModuleProtoBuf.Module module2 = JvmModuleProtoBuf.Module.parseFrom(stream, extensions);
            if (module2 == null) {
                return EMPTY;
            }
            JvmModuleProtoBuf.Module moduleProto = module2;
            LinkedHashMap result2 = new LinkedHashMap();
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getPackagePartsList()) {
                String partShortName;
                int index2;
                Object object;
                Iterator $this$getOrPut$iv;
                String packageFqName = proto.getPackageFqName();
                Map map = result2;
                Intrinsics.checkNotNullExpressionValue(packageFqName, "packageFqName");
                String key$iv22 = packageFqName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv22);
                if (value$iv == null) {
                    boolean bl2 = false;
                    PackageParts answer$iv = new PackageParts(packageFqName);
                    $this$getOrPut$iv.put(key$iv22, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                packageParts2 = (PackageParts)object;
                $this$getOrPut$iv = proto.getShortClassNameList().iterator();
                int key$iv22 = 0;
                while ($this$getOrPut$iv.hasNext()) {
                    index2 = key$iv22++;
                    partShortName = (String)$this$getOrPut$iv.next();
                    Intrinsics.checkNotNullExpressionValue(partShortName, "partShortName");
                    String string2 = ModuleMappingKt.access$internalNameOf(packageFqName, partShortName);
                    List<Integer> list2 = proto.getMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(list2, "proto.multifileFacadeShortNameIdList");
                    ProtocolStringList protocolStringList = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList, "proto.multifileFacadeShortNameList");
                    ((PackageParts)packageParts2).addPart(string2, this.loadMultiFileFacadeInternalName(list2, protocolStringList, index2, packageFqName));
                }
                if (!isJvmPackageNameSupported) continue;
                $this$getOrPut$iv = proto.getClassWithJvmPackageNameShortNameList().iterator();
                key$iv22 = 0;
                while ($this$getOrPut$iv.hasNext()) {
                    int n;
                    index2 = key$iv22++;
                    partShortName = (String)$this$getOrPut$iv.next();
                    List<Integer> list3 = proto.getClassWithJvmPackageNamePackageIdList();
                    Intrinsics.checkNotNullExpressionValue(list3, "proto.classWithJvmPackageNamePackageIdList");
                    Integer n2 = CollectionsKt.getOrNull(list3, index2);
                    if (n2 != null) {
                        n = n2;
                    } else {
                        List<Integer> list4 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkNotNullExpressionValue(list4, "proto.classWithJvmPackageNamePackageIdList");
                        Integer n3 = CollectionsKt.lastOrNull(list4);
                        if (n3 == null) continue;
                        n = n3;
                    }
                    int packageId = n;
                    ProtocolStringList protocolStringList = moduleProto.getJvmPackageNameList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList, "moduleProto.jvmPackageNameList");
                    if ((String)CollectionsKt.getOrNull(protocolStringList, packageId) == null) continue;
                    Intrinsics.checkNotNullExpressionValue(partShortName, "partShortName");
                    String string3 = ModuleMappingKt.access$internalNameOf((String)((Object)jvmPackageName), partShortName);
                    List<Integer> list5 = proto.getClassWithJvmPackageNameMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(list5, "proto.classWithJvmPackag\u2026fileFacadeShortNameIdList");
                    ProtocolStringList protocolStringList2 = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList2, "proto.multifileFacadeShortNameList");
                    ((PackageParts)packageParts2).addPart(string3, this.loadMultiFileFacadeInternalName(list5, protocolStringList2, index2, (String)((Object)jvmPackageName)));
                }
            }
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                Object object;
                String key$iv;
                void $this$getOrPut$iv;
                packageParts2 = result2;
                Intrinsics.checkNotNullExpressionValue(proto.getPackageFqName(), "proto.packageFqName");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String string4 = proto.getPackageFqName();
                    Intrinsics.checkNotNullExpressionValue(string4, "proto.packageFqName");
                    PackageParts answer$iv = new PackageParts(string4);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                PackageParts packageParts3 = (PackageParts)object;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkNotNullExpressionValue(protocolStringList, "proto.shortClassNameList");
                Iterable $this$forEach$iv = protocolStringList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p02 = (String)element$iv;
                    boolean bl4 = false;
                    packageParts3.addMetadataPart(p02);
                }
            }
            ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
            Intrinsics.checkNotNullExpressionValue(stringTable, "moduleProto.stringTable");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
            Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "moduleProto.qualifiedNameTable");
            NameResolverImpl nameResolver2 = new NameResolverImpl(stringTable, qualifiedNameTable);
            List<ProtoBuf.Annotation> list6 = moduleProto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list6, "moduleProto.annotationList");
            Iterable $this$map$iv = list6;
            boolean $i$f$map = false;
            Iterable $i$f$forEach = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void proto;
                jvmPackageName = (ProtoBuf.Annotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(nameResolver2.getQualifiedClassName(proto.getId()));
            }
            List annotations2 = (List)destination$iv$iv;
            Map map = result2;
            List<ProtoBuf.Class> list7 = moduleProto.getOptionalAnnotationClassList();
            Intrinsics.checkNotNullExpressionValue(list7, "moduleProto.optionalAnnotationClassList");
            return new ModuleMapping(version, map, new BinaryModuleData(annotations2, list7, nameResolver2), debugName, null);
        }

        public static /* synthetic */ ModuleMapping loadModuleMapping$default(Companion companion, byte[] byArray, String string2, boolean bl, boolean bl2, JvmMetadataVersion jvmMetadataVersion, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
            }
            return companion.loadModuleMapping(byArray, string2, bl, bl2, jvmMetadataVersion, function1);
        }

        private final String loadMultiFileFacadeInternalName(List<Integer> multifileFacadeIds, List<String> multifileFacadeShortNames, int index2, String packageFqName) {
            String string2;
            String facadeShortName;
            String string3;
            Integer multifileFacadeId;
            Integer n = CollectionsKt.getOrNull(multifileFacadeIds, index2);
            Integer n2 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
            if (n2 != null) {
                int p0 = ((Number)n2).intValue();
                boolean bl = false;
                string3 = CollectionsKt.getOrNull(multifileFacadeShortNames, p0);
            } else {
                string3 = null;
            }
            String string4 = facadeShortName = string3;
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                string2 = ModuleMappingKt.access$internalNameOf(packageFqName, it);
            } else {
                string2 = null;
            }
            return string2;
        }

        private final BinaryModuleData emptyBinaryData() {
            List<String> list2 = CollectionsKt.emptyList();
            List<ProtoBuf.Class> list3 = CollectionsKt.emptyList();
            ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue(stringTable, "getDefaultInstance()");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "getDefaultInstance()");
            return new BinaryModuleData(list2, list3, new NameResolverImpl(stringTable, qualifiedNameTable));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ BinaryModuleData access$emptyBinaryData(Companion $this) {
            return $this.emptyBinaryData();
        }
    }
}

