/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ContractNotAllowedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ContractNotAllowedCallChecker
implements CallChecker {
    @NotNull
    public static final ContractNotAllowedCallChecker INSTANCE = new ContractNotAllowedCallChecker();

    private ContractNotAllowedCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean inFunctionBodyBlock;
        FunctionDescriptor functionDescriptor;
        Ref.BooleanRef hasErrors;
        KtElement callElement;
        boolean allowedOnMembers;
        block21: {
            LexicalScope scope2;
            block20: {
                boolean acceptableParent;
                boolean bl;
                Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
                Intrinsics.checkNotNullParameter(reportOn, "reportOn");
                Intrinsics.checkNotNullParameter(context, "context");
                if (!(reportOn instanceof KtElement)) {
                    return;
                }
                Object obj = resolvedCall2.getResultingDescriptor();
                FunctionDescriptor functionDescriptor2 = obj instanceof FunctionDescriptor ? (FunctionDescriptor)obj : null;
                if (functionDescriptor2 == null) {
                    return;
                }
                FunctionDescriptor descriptor2 = functionDescriptor2;
                if (!PsiContractsUtilsKt.isContractCallDescriptor(descriptor2)) {
                    return;
                }
                allowedOnMembers = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowContractsForNonOverridableMembers);
                KtElement ktElement = resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue(ktElement, "resolvedCall.call.callElement");
                callElement = ktElement;
                hasErrors = new Ref.BooleanRef();
                scope2 = context.getScope();
                DeclarationDescriptor declarationDescriptor = scope2.getOwnerDescriptor();
                FunctionDescriptor functionDescriptor3 = functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                if (functionDescriptor == null || functionDescriptor instanceof PropertyAccessorDescriptor) {
                    ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context, reportOn, "Contracts are allowed only for functions");
                }
                inFunctionBodyBlock = true;
                DeclarationDescriptor declarationOwner = scope2.getOwnerDescriptor().getContainingDeclaration();
                if (allowedOnMembers) {
                    DeclarationDescriptor owner = declarationOwner;
                    boolean result2 = true;
                    while (!(owner instanceof PackageFragmentDescriptor)) {
                        if (!(owner instanceof ClassDescriptor)) {
                            result2 = false;
                            break;
                        }
                        owner = ((ClassDescriptor)owner).getContainingDeclaration();
                    }
                    bl = result2;
                } else {
                    bl = acceptableParent = declarationOwner instanceof PackageFragmentDescriptor;
                }
                if (!acceptableParent || scope2.getKind() != LexicalScopeKind.CODE_BLOCK) break block20;
                HierarchicalScope hierarchicalScope = scope2.getParent();
                LexicalScope lexicalScope = hierarchicalScope instanceof LexicalScope ? (LexicalScope)hierarchicalScope : null;
                if ((lexicalScope != null ? lexicalScope.getKind() : null) == LexicalScopeKind.FUNCTION_INNER_SCOPE) break block21;
            }
            if (scope2.getKind() == LexicalScopeKind.FUNCTION_INNER_SCOPE) {
                ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context, reportOn, "Contracts are allowed only in function body block");
                inFunctionBodyBlock = false;
            } else {
                String message2 = allowedOnMembers ? "Contracts are allowed only for functions" : "Contracts are allowed only for top-level functions";
                ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context, reportOn, message2);
            }
        }
        FunctionDescriptor functionDescriptor4 = functionDescriptor;
        boolean bl = functionDescriptor4 != null ? functionDescriptor4.isOperator() : false;
        if (bl) {
            ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context, reportOn, "Contracts are not allowed for operator functions");
        }
        if (!allowedOnMembers) {
            FunctionDescriptor functionDescriptor5 = functionDescriptor;
            boolean bl2 = functionDescriptor5 != null ? ModalityUtilsKt.isOverridable(functionDescriptor5) : false;
            if (bl2) {
                ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context, reportOn, "Contracts are not allowed for open functions");
            }
        }
        if (allowedOnMembers) {
            FunctionDescriptor functionDescriptor6 = functionDescriptor;
            boolean bl3 = functionDescriptor6 != null ? ModalityUtilsKt.isOverridableOrOverrides(functionDescriptor6) : false;
            if (bl3) {
                ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context, reportOn, "Contracts are not allowed for open or override functions");
            }
        }
        if (!KtPsiUtilKt.isFirstStatement(callElement) && inFunctionBodyBlock) {
            ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context, reportOn, "Contract should be the first statement");
        }
        if (hasErrors.element) {
            context.getTrace().record(BindingContext.CONTRACT_NOT_ALLOWED, callElement, true);
        }
    }

    private static final void check$contractNotAllowed(Ref.BooleanRef hasErrors, CallCheckerContext $context, PsiElement $reportOn, String message2) {
        hasErrors.element = true;
        $context.getTrace().report(Errors.CONTRACT_NOT_ALLOWED.on((KtElement)$reportOn, message2));
    }
}

