/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0014*\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\u0014H\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020 *\u0006\u0012\u0002\b\u00030\nH\u0002J\f\u0010!\u001a\u00020\u0014*\u00020\u0014H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "comparisonOperatorTokens", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "inferPrimitiveNumericComparisonType", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "leftTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightTypes", "comparison", "Lorg/jetbrains/kotlin/psi/KtExpression;", "leastCommonPrimitiveNumericType", "t1", "t2", "findPrimitiveOrNullablePrimitiveType", "getPrimitiveTypeOrSupertype", "getStableTypesForExpression", "expression", "isStandardComparison", "", "promoteIntegerTypeToIntIfRequired", "frontend"})
@SourceDebugExtension(value={"SMAP\nPrimitiveNumericComparisonCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveNumericComparisonCallChecker.kt\norg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonCallChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class PrimitiveNumericComparisonCallChecker
implements CallChecker {
    @NotNull
    public static final PrimitiveNumericComparisonCallChecker INSTANCE = new PrimitiveNumericComparisonCallChecker();
    @NotNull
    private static final Set<KtSingleValueToken> comparisonOperatorTokens;

    private PrimitiveNumericComparisonCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!CollectionsKt.contains((Iterable)comparisonOperatorTokens, binaryExpression.getOperationReference().getReferencedNameElementType())) {
            return;
        }
        if (!this.isStandardComparison(resolvedCall2)) {
            return;
        }
        KtExpression ktExpression = binaryExpression.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression leftExpr = ktExpression;
        KtExpression ktExpression2 = binaryExpression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression rightExpr = ktExpression2;
        List<KotlinType> leftTypes = this.getStableTypesForExpression(context, leftExpr);
        List<KotlinType> rightTypes = this.getStableTypesForExpression(context, rightExpr);
        this.inferPrimitiveNumericComparisonType(context.getTrace(), leftTypes, rightTypes, binaryExpression);
    }

    public final void inferPrimitiveNumericComparisonType(@NotNull BindingTrace trace, @NotNull List<? extends KotlinType> leftTypes, @NotNull List<? extends KotlinType> rightTypes, @NotNull KtExpression comparison) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(leftTypes, "leftTypes");
        Intrinsics.checkNotNullParameter(rightTypes, "rightTypes");
        Intrinsics.checkNotNullParameter(comparison, "comparison");
        KotlinType kotlinType = this.findPrimitiveOrNullablePrimitiveType(leftTypes);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftPrimitiveOrNullableType = kotlinType;
        KotlinType kotlinType2 = this.findPrimitiveOrNullablePrimitiveType(rightTypes);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightPrimitiveOrNullableType = kotlinType2;
        KotlinType leftPrimitiveType = TypeUtilsKt.makeNotNullable(leftPrimitiveOrNullableType);
        KotlinType rightPrimitiveType = TypeUtilsKt.makeNotNullable(rightPrimitiveOrNullableType);
        KotlinType leastCommonType = this.leastCommonPrimitiveNumericType(leftPrimitiveType, rightPrimitiveType);
        trace.record(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, comparison, new PrimitiveNumericComparisonInfo(leastCommonType, leftPrimitiveType, rightPrimitiveType, leftPrimitiveOrNullableType, rightPrimitiveOrNullableType));
    }

    private final boolean isStandardComparison(ResolvedCall<?> $this$isStandardComparison) {
        return $this$isStandardComparison.getExtensionReceiver() == null && $this$isStandardComparison.getDispatchReceiver() != null && KotlinBuiltIns.isUnderKotlinPackage((DeclarationDescriptor)$this$isStandardComparison.getResultingDescriptor());
    }

    private final KotlinType leastCommonPrimitiveNumericType(KotlinType t1, KotlinType t2) {
        KotlinType kotlinType;
        KotlinType pt1 = this.promoteIntegerTypeToIntIfRequired(t1);
        KotlinType pt2 = this.promoteIntegerTypeToIntIfRequired(t2);
        if (TypeUtilsKt.isDouble(pt1) || TypeUtilsKt.isDouble(pt2)) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(t1).getDoubleType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "t1.builtIns.doubleType");
            kotlinType = simpleType2;
        } else if (TypeUtilsKt.isFloat(pt1) || TypeUtilsKt.isFloat(pt2)) {
            SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(t1).getFloatType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "t1.builtIns.floatType");
            kotlinType = simpleType3;
        } else if (TypeUtilsKt.isLong(pt1) || TypeUtilsKt.isLong(pt2)) {
            SimpleType simpleType4 = TypeUtilsKt.getBuiltIns(t1).getLongType();
            Intrinsics.checkNotNullExpressionValue(simpleType4, "t1.builtIns.longType");
            kotlinType = simpleType4;
        } else if (TypeUtilsKt.isInt(pt1) || TypeUtilsKt.isInt(pt2)) {
            SimpleType simpleType5 = TypeUtilsKt.getBuiltIns(t1).getIntType();
            Intrinsics.checkNotNullExpressionValue(simpleType5, "t1.builtIns.intType");
            kotlinType = simpleType5;
        } else {
            throw new AssertionError((Object)("Unexpected types: t1=" + t1 + ", t2=" + t2));
        }
        return kotlinType;
    }

    private final KotlinType promoteIntegerTypeToIntIfRequired(KotlinType $this$promoteIntegerTypeToIntIfRequired) {
        KotlinType kotlinType;
        if (!TypeUtilsKt.isPrimitiveNumberType($this$promoteIntegerTypeToIntIfRequired)) {
            throw new AssertionError((Object)("Primitive number type expected: " + $this$promoteIntegerTypeToIntIfRequired));
        }
        if (TypeUtilsKt.isByte($this$promoteIntegerTypeToIntIfRequired) || TypeUtilsKt.isShort($this$promoteIntegerTypeToIntIfRequired)) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns($this$promoteIntegerTypeToIntIfRequired).getIntType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.intType");
            kotlinType = simpleType2;
        } else {
            kotlinType = $this$promoteIntegerTypeToIntIfRequired;
        }
        return kotlinType;
    }

    private final List<KotlinType> getStableTypesForExpression(CallCheckerContext $this$getStableTypesForExpression, KtExpression expression2) {
        KotlinType kotlinType = $this$getStableTypesForExpression.getTrace().getBindingContext().getType(expression2);
        if (kotlinType == null) {
            return CollectionsKt.emptyList();
        }
        KotlinType type2 = kotlinType;
        DataFlowValueFactory dataFlowValueFactory = $this$getStableTypesForExpression.getDataFlowValueFactory();
        BindingContext bindingContext2 = $this$getStableTypesForExpression.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext2, "trace.bindingContext");
        DataFlowValue dataFlowValue2 = dataFlowValueFactory.createDataFlowValue(expression2, type2, bindingContext2, $this$getStableTypesForExpression.getResolutionContext().scope.getOwnerDescriptor());
        Object object = (KotlinTypeInfo)$this$getStableTypesForExpression.getTrace().get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (object == null || (object = ((KotlinTypeInfo)object).getDataFlowInfo()) == null) {
            return CollectionsKt.emptyList();
        }
        Object dataFlowInfo = object;
        Set<KotlinType> stableTypes = dataFlowInfo.getStableTypes(dataFlowValue2, $this$getStableTypesForExpression.getLanguageVersionSettings());
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(type2), (Iterable)stableTypes);
    }

    private final KotlinType findPrimitiveOrNullablePrimitiveType(List<? extends KotlinType> $this$findPrimitiveOrNullablePrimitiveType) {
        KotlinType kotlinType;
        block1: {
            for (KotlinType it : (Iterable)$this$findPrimitiveOrNullablePrimitiveType) {
                boolean bl = false;
                KotlinType kotlinType2 = INSTANCE.getPrimitiveTypeOrSupertype(it);
                if (kotlinType2 == null) continue;
                kotlinType = kotlinType2;
                break block1;
            }
            kotlinType = null;
        }
        return kotlinType;
    }

    private final KotlinType getPrimitiveTypeOrSupertype(KotlinType $this$getPrimitiveTypeOrSupertype) {
        KotlinType kotlinType;
        block3: {
            if ($this$getPrimitiveTypeOrSupertype.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                for (KotlinType it : (Iterable)TypeUtilsKt.immediateSupertypes($this$getPrimitiveTypeOrSupertype)) {
                    boolean bl = false;
                    KotlinType kotlinType2 = INSTANCE.getPrimitiveTypeOrSupertype(it);
                    if (kotlinType2 == null) continue;
                    kotlinType = kotlinType2;
                    break block3;
                }
                kotlinType = null;
            } else {
                kotlinType = TypeUtilsKt.isPrimitiveNumberOrNullableType($this$getPrimitiveTypeOrSupertype) ? $this$getPrimitiveTypeOrSupertype : null;
            }
        }
        return kotlinType;
    }

    static {
        KtSingleValueToken[] ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ};
        comparisonOperatorTokens = SetsKt.setOf(ktSingleValueTokenArray);
    }
}

