/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Rule(key="S1862")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/sonarsource/kotlin/checks/IdenticalConditionsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "checkConditions", "", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "conditions", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "collectConditions", "ifTree", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "list", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitIfExpression", "expression", "kotlinFileContext", "visitWhenExpression", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nIdenticalConditionsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdenticalConditionsCheck.kt\norg/sonarsource/kotlin/checks/IdenticalConditionsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1603#2,9:86\n1855#2:95\n1856#2:101\n1612#2:102\n766#2:103\n857#2,2:104\n1549#2:106\n1620#2,3:107\n11065#3:96\n11400#3,3:97\n1#4:100\n*S KotlinDebug\n*F\n+ 1 IdenticalConditionsCheck.kt\norg/sonarsource/kotlin/checks/IdenticalConditionsCheck\n*L\n67#1:86,9\n67#1:95\n67#1:101\n67#1:102\n75#1:103\n75#1:104,2\n75#1:106\n75#1:107,3\n68#1:96\n68#1:97,3\n67#1:100\n*E\n"})
public final class IdenticalConditionsCheck
extends AbstractCheck {
    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.checkConditions(kotlinFileContext, this.collectConditions(expression2));
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!(expression2.getParent() instanceof KtIfExpression) && !(expression2.getParent().getParent() instanceof KtIfExpression)) {
            this.checkConditions(kotlinFileContext, this.collectConditions(expression2, new ArrayList()));
        }
    }

    private final void checkConditions(KotlinFileContext ctx, List<? extends KtElement> conditions2) {
        for (List<KtElement> group : SyntacticEquivalence.INSTANCE.findDuplicatedGroups(conditions2)) {
            KtElement original = group.get(0);
            group.stream().skip(1L).forEach(arg_0 -> IdenticalConditionsCheck.checkConditions$lambda$0(new Function1<KtElement, Unit>(ctx, original, this){
                final /* synthetic */ KotlinFileContext $ctx;
                final /* synthetic */ KtElement $original;
                final /* synthetic */ IdenticalConditionsCheck this$0;
                {
                    this.$ctx = $ctx;
                    this.$original = $original;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(KtElement duplicated) {
                    TextRange originalRange = KotlinTextRanges.INSTANCE.textRange(this.$ctx, this.$original);
                    AbstractCheck abstractCheck = this.this$0;
                    Intrinsics.checkNotNull(duplicated);
                    AbstractCheck.reportIssue$default(abstractCheck, this.$ctx, (PsiElement)duplicated, "This condition duplicates the one on line " + originalRange.start().line() + ".", CollectionsKt.listOf(new SecondaryLocation(originalRange, "Original")), null, 8, null);
                }
            }, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtElement> collectConditions(KtWhenExpression whenExpression) {
        void $this$mapTo$iv$iv;
        List it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List<KtWhenEntry> list2 = whenExpression.getEntries();
        Intrinsics.checkNotNullExpressionValue(list2, "getEntries(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtWhenEntry it2 = (KtWhenEntry)element$iv$iv;
            boolean bl2 = false;
            KtWhenCondition[] ktWhenConditionArray = it2.getConditions();
            Intrinsics.checkNotNullExpressionValue(ktWhenConditionArray, "getConditions(...)");
            Object[] $this$map$iv = ktWhenConditionArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv2) {
                KtElement ktElement;
                void whenCondition;
                KtWhenCondition ktWhenCondition = (KtWhenCondition)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                if (whenCondition instanceof KtWhenConditionWithExpression) {
                    KtExpression ktExpression = ((KtWhenConditionWithExpression)whenCondition).getExpression();
                    Intrinsics.checkNotNull(ktExpression);
                    ktElement = this.skipParentheses(ktExpression);
                } else {
                    ktElement = (KtElement)whenCondition;
                }
                collection.add(ktElement);
            }
            List it$iv$iv = (List)destination$iv$iv2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() == 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((KtElement)CollectionsKt.single(it));
        }
        return (List)destination$iv$iv;
    }

    private final List<KtElement> collectConditions(KtIfExpression ifTree, List<KtExpression> list2) {
        KtExpression ktExpression = ifTree.getCondition();
        Intrinsics.checkNotNull(ktExpression);
        list2.add(this.skipParentheses(ktExpression));
        KtExpression elseBranch = ifTree.getElse();
        return elseBranch instanceof KtIfExpression ? this.collectConditions((KtIfExpression)elseBranch, list2) : list2;
    }

    private static final void checkConditions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }
}

