/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"lazyInitializationMatcher", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "isInitializingCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isLazyInitializingCall", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isSingletonClassCandidate", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "isStaticProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nSingletonPatternCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingletonPatternCheck.kt\norg/sonarsource/kotlin/checks/SingletonPatternCheckKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1726#2,3:139\n*S KotlinDebug\n*F\n+ 1 SingletonPatternCheck.kt\norg/sonarsource/kotlin/checks/SingletonPatternCheckKt\n*L\n90#1:139,3\n*E\n"})
public final class SingletonPatternCheckKt {
    @NotNull
    private static final FunMatcherImpl lazyInitializationMatcher = FunMatcherKt.FunMatcher$default(null, "lazy", null, "kotlin", false, null, null, null, null, null, null, 2037, null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSingletonClassCandidate(KtClass klass) {
        KtConstructor it;
        List<KtConstructor<?>> constructors2 = KtClassOrObjectKt.getAllConstructors(klass);
        if (KtPsiUtilKt.isPrivate(klass)) return true;
        if (((Collection)constructors2).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$all$iv = constructors2;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (KtConstructor)element$iv;
            boolean bl2 = false;
        } while (KtPsiUtilKt.isPrivate(it));
        return false;
    }

    private static final boolean isInitializingCall(KtCallExpression callExpression) {
        PsiElement psiElement = callExpression.getParent();
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            return false;
        }
        KtProperty property = ktProperty;
        return SingletonPatternCheckKt.isStaticProperty(property);
    }

    private static final boolean isLazyInitializingCall(KtCallExpression callExpression, BindingContext bindingContext2) {
        PsiElement psiElement = callExpression.getParent();
        KtBlockExpression ktBlockExpression = psiElement instanceof KtBlockExpression ? (KtBlockExpression)psiElement : null;
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        List<KtExpression> list2 = bodyExpression.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
        if (CollectionsKt.last(list2) != callExpression) {
            return false;
        }
        PsiElement psiElement2 = bodyExpression.getParent();
        KtFunctionLiteral ktFunctionLiteral = psiElement2 instanceof KtFunctionLiteral ? (KtFunctionLiteral)psiElement2 : null;
        PsiElement psiElement3 = ktFunctionLiteral != null ? ktFunctionLiteral.getParent() : null;
        PsiElement psiElement4 = psiElement3 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement3 : null;
        PsiElement psiElement5 = psiElement4 != null ? psiElement4.getParent() : null;
        PsiElement psiElement6 = psiElement5 instanceof KtLambdaArgument ? (KtLambdaArgument)psiElement5 : null;
        PsiElement psiElement7 = psiElement6 != null ? psiElement6.getParent() : null;
        KtCallExpression ktCallExpression = psiElement7 instanceof KtCallExpression ? (KtCallExpression)psiElement7 : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression call2 = ktCallExpression;
        psiElement4 = call2.getParent();
        KtPropertyDelegate ktPropertyDelegate = psiElement4 instanceof KtPropertyDelegate ? (KtPropertyDelegate)psiElement4 : null;
        psiElement6 = ktPropertyDelegate != null ? ktPropertyDelegate.getParent() : null;
        KtProperty ktProperty = psiElement6 instanceof KtProperty ? (KtProperty)psiElement6 : null;
        if (ktProperty == null) {
            return false;
        }
        KtProperty property = ktProperty;
        return SingletonPatternCheckKt.isStaticProperty(property) && lazyInitializationMatcher.matches(CallUtilKt.getResolvedCall(call2, bindingContext2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isStaticProperty(KtProperty property) {
        if (property.isTopLevel()) return true;
        PsiElement psiElement = property.getParent();
        KtClassBody ktClassBody = psiElement instanceof KtClassBody ? (KtClassBody)psiElement : null;
        PsiElement psiElement2 = ktClassBody != null ? ktClassBody.getParent() : null;
        if (!(psiElement2 instanceof KtObjectDeclaration)) return false;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)psiElement2;
        if (ktObjectDeclaration == null) return false;
        boolean bl = ktObjectDeclaration.isCompanion();
        if (!bl) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isInitializingCall(KtCallExpression callExpression) {
        return SingletonPatternCheckKt.isInitializingCall(callExpression);
    }

    public static final /* synthetic */ boolean access$isLazyInitializingCall(KtCallExpression callExpression, BindingContext bindingContext2) {
        return SingletonPatternCheckKt.isLazyInitializingCall(callExpression, bindingContext2);
    }

    public static final /* synthetic */ boolean access$isSingletonClassCandidate(KtClass klass) {
        return SingletonPatternCheckKt.isSingletonClassCandidate(klass);
    }
}

