/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007H\u0002\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0005*\u00020\u0003H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010\f\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u00060\u0005*\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"shouldBeChecked", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getUnusedParameters", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "notUsedIn", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "unusedParametersList", "kotlin.jvm.PlatformType", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nUnusedFunctionParameterCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedFunctionParameterCheck.kt\norg/sonarsource/kotlin/checks/UnusedFunctionParameterCheckKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n242#2:101\n253#2,9:102\n274#2:111\n766#3:112\n857#3,2:113\n*S KotlinDebug\n*F\n+ 1 UnusedFunctionParameterCheck.kt\norg/sonarsource/kotlin/checks/UnusedFunctionParameterCheckKt\n*L\n92#1:101\n92#1:102,9\n92#1:111\n96#1:112\n96#1:113,2\n*E\n"})
public final class UnusedFunctionParameterCheckKt {
    private static final boolean shouldBeChecked(KtNamedFunction function2) {
        return function2.hasBody() && (function2.isTopLevel() || KtPsiUtilKt.isPrivate(function2) || function2.isAnonymous());
    }

    private static final List<KtParameter> getUnusedParameters(KtNamedFunction $this$getUnusedParameters) {
        List<KtParameter> list2 = $this$getUnusedParameters.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        return SequencesKt.toList(SequencesKt.filter(CollectionsKt.asSequence((Iterable)list2), (Function1)new Function1<KtParameter, Boolean>($this$getUnusedParameters){
            final /* synthetic */ KtNamedFunction $this_getUnusedParameters;
            {
                this.$this_getUnusedParameters = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(KtParameter it) {
                Intrinsics.checkNotNull(it);
                return UnusedFunctionParameterCheckKt.access$notUsedIn(it, this.$this_getUnusedParameters);
            }
        }));
    }

    private static final List<KtNamedDeclaration> getUnusedParameters(KtLambdaExpression $this$getUnusedParameters) {
        List<KtParameter> list2 = $this$getUnusedParameters.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        return SequencesKt.toList(SequencesKt.flatMapIterable(CollectionsKt.asSequence((Iterable)list2), (Function1)new Function1<KtParameter, List<? extends KtNamedDeclaration>>($this$getUnusedParameters){
            final /* synthetic */ KtLambdaExpression $this_getUnusedParameters;
            {
                this.$this_getUnusedParameters = $receiver;
                super(1);
            }

            @NotNull
            public final List<KtNamedDeclaration> invoke(KtParameter it) {
                Intrinsics.checkNotNull(it);
                return UnusedFunctionParameterCheckKt.access$unusedParametersList(it, this.$this_getUnusedParameters);
            }
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean notUsedIn(KtNamedDeclaration $this$notUsedIn, KtElement ktElement) {
        void $this$anyDescendantOfType$iv;
        if (Intrinsics.areEqual($this$notUsedIn.getName(), "_")) return false;
        PsiElement psiElement = ktElement;
        Function1 predicate$iv = new Function1<KtNameReferenceExpression, Boolean>($this$notUsedIn){
            final /* synthetic */ KtNamedDeclaration $this_notUsedIn;
            {
                this.$this_notUsedIn = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtNameReferenceExpression it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getReferencedName(), this.$this_notUsedIn.getName());
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtNamedDeclaration> unusedParametersList(KtParameter $this$unusedParametersList, KtElement ktElement) {
        List<KtNamedDeclaration> list2;
        if ($this$unusedParametersList.getDestructuringDeclaration() != null) {
            void $this$filterTo$iv$iv;
            KtDestructuringDeclaration ktDestructuringDeclaration = $this$unusedParametersList.getDestructuringDeclaration();
            Intrinsics.checkNotNull(ktDestructuringDeclaration);
            List<KtDestructuringDeclarationEntry> list3 = ktDestructuringDeclaration.getEntries();
            Intrinsics.checkNotNullExpressionValue(list3, "getEntries(...)");
            Iterable $this$filter$iv = list3;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!UnusedFunctionParameterCheckKt.notUsedIn(it, ktElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = UnusedFunctionParameterCheckKt.notUsedIn($this$unusedParametersList, ktElement) ? CollectionsKt.listOf($this$unusedParametersList) : CollectionsKt.emptyList();
        }
        return list2;
    }

    public static final /* synthetic */ boolean access$shouldBeChecked(KtNamedFunction function2) {
        return UnusedFunctionParameterCheckKt.shouldBeChecked(function2);
    }

    public static final /* synthetic */ List access$getUnusedParameters(KtNamedFunction $receiver) {
        return UnusedFunctionParameterCheckKt.getUnusedParameters($receiver);
    }

    public static final /* synthetic */ List access$getUnusedParameters(KtLambdaExpression $receiver) {
        return UnusedFunctionParameterCheckKt.getUnusedParameters($receiver);
    }

    public static final /* synthetic */ boolean access$notUsedIn(KtNamedDeclaration $receiver, KtElement ktElement) {
        return UnusedFunctionParameterCheckKt.notUsedIn($receiver, ktElement);
    }

    public static final /* synthetic */ List access$unusedParametersList(KtParameter $receiver, KtElement ktElement) {
        return UnusedFunctionParameterCheckKt.unusedParametersList($receiver, ktElement);
    }
}

