/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.internal.CollectionUtils;

public class ManifestUtil {
    private static final String[] EMPTY = new String[0];

    public static String createManifestClasspath(File jarFile, Collection<File> classpath) {
        ArrayList<String> paths = new ArrayList<String>(classpath.size());
        for (File file2 : classpath) {
            String path = ManifestUtil.constructRelativeClasspathUri(jarFile, file2);
            paths.add(path);
        }
        return CollectionUtils.join(" ", paths);
    }

    private static String constructRelativeClasspathUri(File jarFile, File file2) {
        URI jarFileUri = jarFile.getParentFile().toURI();
        URI fileUri = file2.toURI();
        URI relativeUri = jarFileUri.relativize(fileUri);
        return relativeUri.getRawPath();
    }

    public static List<URI> parseManifestClasspath(File jarFile) {
        ArrayList<URI> manifestClasspath = new ArrayList<URI>();
        for (String value2 : ManifestUtil.readManifestClasspathString(jarFile)) {
            try {
                URI uri = new URI(value2);
                uri = jarFile.toURI().resolve(uri);
                manifestClasspath.add(uri);
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException(e);
            }
        }
        return manifestClasspath;
    }

    private static String[] readManifestClasspathString(File classpathFile) {
        try {
            Manifest manifest2 = ManifestUtil.findManifest(classpathFile);
            if (manifest2 == null) {
                return EMPTY;
            }
            String classpathEntry = manifest2.getMainAttributes().getValue("Class-Path");
            if (classpathEntry == null || classpathEntry.trim().length() == 0) {
                return EMPTY;
            }
            return classpathEntry.split(" ");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Manifest findManifest(File possibleJarFile) throws IOException {
        JarFile jarFile;
        if (!possibleJarFile.exists() || !possibleJarFile.isFile()) {
            return null;
        }
        try {
            jarFile = new JarFile(possibleJarFile);
        }
        catch (ZipException e) {
            return null;
        }
        try {
            Manifest manifest2 = jarFile.getManifest();
            return manifest2;
        }
        finally {
            jarFile.close();
        }
    }
}

