/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.ArrayList;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class CommandLineOptionConfiguration {
    private final String longOption;
    private final String shortOption;
    private final String description;
    private boolean incubating;
    private boolean deprecated;

    CommandLineOptionConfiguration(String longOption, String description2) {
        this(longOption, null, description2);
    }

    CommandLineOptionConfiguration(String longOption, @Nullable String shortOption, String description2) {
        assert (longOption != null) : "longOption cannot be null";
        assert (description2 != null) : "description cannot be null";
        this.longOption = longOption;
        this.shortOption = shortOption;
        this.description = description2;
    }

    public static CommandLineOptionConfiguration create(String longOption, String description2) {
        return new CommandLineOptionConfiguration(longOption, description2);
    }

    public static CommandLineOptionConfiguration create(String longOption, String shortOption, String description2) {
        return new CommandLineOptionConfiguration(longOption, shortOption, description2);
    }

    public CommandLineOptionConfiguration incubating() {
        this.incubating = true;
        return this;
    }

    public CommandLineOptionConfiguration deprecated() {
        this.deprecated = true;
        return this;
    }

    public String getLongOption() {
        return this.longOption;
    }

    @Nullable
    public String getShortOption() {
        return this.shortOption;
    }

    public String[] getAllOptions() {
        ArrayList<String> allOptions = new ArrayList<String>();
        allOptions.add(this.longOption);
        if (this.shortOption != null) {
            allOptions.add(this.shortOption);
        }
        return allOptions.toArray(new String[allOptions.size()]);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIncubating() {
        return this.incubating;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }
}

