/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classpath.ClassPath;

public class VisitableURLClassLoader
extends URLClassLoader
implements ClassLoaderHierarchy {
    private final Map<Object, Object> userData = new HashMap<Object, Object>();
    private final String name;

    public synchronized <T> T getUserData(Object consumerId, Factory<T> onMiss) {
        if (this.userData.containsKey(consumerId)) {
            return Cast.uncheckedCast(this.userData.get(consumerId));
        }
        T value2 = onMiss.create();
        this.userData.put(consumerId, value2);
        return value2;
    }

    public VisitableURLClassLoader(String name, ClassLoader parent2, Collection<URL> urls) {
        this(name, urls.toArray(new URL[0]), parent2);
    }

    public VisitableURLClassLoader(String name, ClassLoader parent2, ClassPath classPath2) {
        this(name, classPath2.getAsURLArray(), parent2);
    }

    private VisitableURLClassLoader(String name, URL[] classpath, ClassLoader parent2) {
        super(classpath, parent2);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return VisitableURLClassLoader.class.getSimpleName() + "(" + this.name + ")";
    }

    @Override
    public void visit(ClassLoaderVisitor visitor2) {
        URL[] urls = this.getURLs();
        visitor2.visitSpec(new Spec(this.name, Arrays.asList(urls)));
        visitor2.visitClassPath(urls);
        visitor2.visitParent(this.getParent());
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static class Spec
    extends ClassLoaderSpec {
        final String name;
        final List<URL> classpath;

        public String getName() {
            return this.name;
        }

        public Spec(String name, List<URL> classpath) {
            this.name = name;
            this.classpath = classpath;
        }

        public List<URL> getClasspath() {
            return this.classpath;
        }

        public String toString() {
            return "{url-class-loader name:" + this.name + ", classpath:" + this.classpath + "}";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return this.classpath.equals(other.classpath);
        }

        public int hashCode() {
            return this.classpath.hashCode();
        }
    }
}

