/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class ThreadFactoryImpl
implements ThreadFactory {
    private final AtomicLong counter = new AtomicLong();
    private final String displayName;
    @Nullable
    private final ClassLoader contextClassloader;

    public ThreadFactoryImpl(String displayName, @Nullable ClassLoader contextClassloader) {
        this.displayName = displayName;
        this.contextClassloader = contextClassloader;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread2 = new Thread(r);
        thread2.setName(this.nextThreadName());
        thread2.setContextClassLoader(this.contextClassloader);
        return thread2;
    }

    private String nextThreadName() {
        long count = this.counter.incrementAndGet();
        return count == 1L ? this.displayName : this.displayName + " Thread " + count;
    }
}

