/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.reflect.CachedInvokable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.ReflectionCache;

public class DirectInstantiator
implements Instantiator {
    public static final Instantiator INSTANCE = new DirectInstantiator();
    private final ConstructorCache constructorCache = new ConstructorCache();

    public static <T> T instantiate(Class<? extends T> type2, Object ... params) {
        return INSTANCE.newInstance(type2, params);
    }

    private DirectInstantiator() {
    }

    @Override
    public <T> T newInstance(Class<? extends T> type2, Object ... params) {
        try {
            Class<?>[] argTypes = this.wrapArgs(params);
            Constructor match = null;
            while (match == null) {
                match = (Constructor)((CachedConstructor)this.constructorCache.get(type2, argTypes)).getMethod();
            }
            return type2.cast(match.newInstance(params));
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException(type2, e.getCause());
        }
        catch (Throwable t) {
            throw new ObjectInstantiationException(type2, t);
        }
    }

    private Class<?>[] wrapArgs(Object[] params) {
        Class[] result2 = new Class[params.length];
        for (int i = 0; i < result2.length; ++i) {
            Object param = params[i];
            if (param == null) continue;
            Class<?> pType = param.getClass();
            if (pType.isPrimitive()) {
                pType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(pType);
            }
            result2[i] = pType;
        }
        return result2;
    }

    private static class CachedConstructor
    extends CachedInvokable<Constructor<?>> {
        public CachedConstructor(Constructor<?> ctor) {
            super(ctor);
        }
    }

    @VisibleForTesting
    public static class ConstructorCache
    extends ReflectionCache<CachedConstructor> {
        @Override
        protected CachedConstructor create(Class<?> receiver, Class<?>[] argumentTypes2) {
            Constructor<?>[] constructors2 = receiver.getConstructors();
            Constructor<?> match = null;
            for (Constructor<?> constructor : constructors2) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != argumentTypes2.length || !this.isMatch(argumentTypes2, parameterTypes)) continue;
                if (match != null) {
                    throw new IllegalArgumentException(String.format("Found multiple public constructors for %s which accept parameters [%s].", receiver, this.prettify(argumentTypes2)));
                }
                match = constructor;
            }
            if (match == null) {
                throw new IllegalArgumentException(String.format("Could not find any public constructor for %s which accepts parameters [%s].", receiver, this.prettify(argumentTypes2)));
            }
            return new CachedConstructor(match);
        }

        private String prettify(Class<?>[] argumentTypes2) {
            return Joiner.on(", ").join(Iterables.transform(Arrays.asList(argumentTypes2), new Function<Class<?>, String>(){

                @Override
                public String apply(Class<?> input) {
                    if (input == null) {
                        return "null";
                    }
                    return input.getName();
                }
            }));
        }

        private boolean isMatch(Class<?>[] argumentTypes2, Class<?>[] parameterTypes) {
            for (int i = 0; i < argumentTypes2.length; ++i) {
                Class<?> argumentType = argumentTypes2[i];
                Class<?> parameterType = parameterTypes[i];
                boolean primitive = parameterType.isPrimitive();
                if (primitive) {
                    if (argumentType == null) {
                        return false;
                    }
                    parameterType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(parameterType);
                }
                if (argumentType == null || parameterType.isAssignableFrom(argumentType)) continue;
                return false;
            }
            return true;
        }
    }
}

