/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.gradle.internal.impldep.javax.inject.Inject;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.TypeStringFormatter;

final class InjectUtil {
    static Constructor<?> selectConstructor(Class<?> type2) {
        if (InjectUtil.isInnerClass(type2)) {
            throw new ServiceValidationException(String.format("Unable to select constructor for non-static inner class %s.", InjectUtil.format(type2)));
        }
        Constructor<?>[] constructors2 = type2.getDeclaredConstructors();
        if (constructors2.length == 1) {
            Constructor<?> constructor = constructors2[0];
            if (InjectUtil.isPublicOrPackageScoped(constructor)) {
                return constructor;
            }
            if (constructor.getAnnotation(Inject.class) != null) {
                return constructor;
            }
        }
        Constructor<?> match = null;
        for (Constructor<?> constructor : constructors2) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            if (match != null) {
                throw new ServiceValidationException(String.format("Multiple constructor annotated with @Inject for %s.", InjectUtil.format(type2)));
            }
            match = constructor;
        }
        if (match == null) {
            throw new ServiceValidationException(String.format("Expected a single non-private constructor, or one constructor annotated with @Inject for %s.", InjectUtil.format(type2)));
        }
        return match;
    }

    private static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    private static boolean isPublicOrPackageScoped(Constructor<?> constructor) {
        return Modifier.isPublic(constructor.getModifiers()) || InjectUtil.isPackagePrivate(constructor.getModifiers());
    }

    static boolean isPackagePrivate(int modifiers) {
        return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
    }

    private static String format(Type type2) {
        return TypeStringFormatter.format(type2);
    }

    private InjectUtil() {
    }
}

