/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.progress.ProgressListener;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;

public class ProgressLoggingConsumerActionExecutor
implements ConsumerActionExecutor {
    private final ConsumerActionExecutor actionExecutor;
    private final LoggingProvider loggingProvider;

    public ProgressLoggingConsumerActionExecutor(ConsumerActionExecutor actionExecutor, LoggingProvider loggingProvider) {
        this.actionExecutor = actionExecutor;
        this.loggingProvider = loggingProvider;
    }

    @Override
    public void stop() {
        this.actionExecutor.stop();
    }

    @Override
    public String getDisplayName() {
        return this.actionExecutor.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(ConsumerAction<T> action) throws UnsupportedOperationException, IllegalStateException {
        ConsumerOperationParameters parameters2 = action.getParameters();
        ProgressListenerAdapter listener = new ProgressListenerAdapter(parameters2.getProgressListener());
        ListenerManager listenerManager = this.loggingProvider.getListenerManager();
        listenerManager.addListener(listener);
        try {
            T t;
            ProgressLogger progressLogger = this.loggingProvider.getProgressLoggerFactory().newOperation(ProgressLoggingConsumerActionExecutor.class);
            progressLogger.setDescription("Build");
            progressLogger.started();
            try {
                t = this.actionExecutor.run(action);
                progressLogger.completed();
            }
            catch (Throwable throwable) {
                progressLogger.completed();
                throw throwable;
            }
            return t;
        }
        finally {
            listenerManager.removeListener(listener);
        }
    }

    @Override
    public void disconnect() {
        this.actionExecutor.disconnect();
    }

    private static class ProgressListenerAdapter
    implements ProgressListener {
        private final ProgressListenerVersion1 progressListener;

        public ProgressListenerAdapter(ProgressListenerVersion1 progressListener) {
            this.progressListener = progressListener;
        }

        @Override
        public void started(ProgressStartEvent event) {
            this.progressListener.onOperationStart(event.getDescription());
        }

        @Override
        public void progress(ProgressEvent event) {
        }

        @Override
        public void completed(ProgressCompleteEvent event) {
            this.progressListener.onOperationEnd();
        }
    }
}

