/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ToolingParameterProxy
implements InvocationHandler {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        if (ToolingParameterProxy.isSetter(method)) {
            this.properties.put(ToolingParameterProxy.getPropertyName(method.getName()), args2[0]);
        } else if (ToolingParameterProxy.isGetter(method)) {
            return this.properties.get(ToolingParameterProxy.getPropertyName(method.getName()));
        }
        return null;
    }

    static void validateParameter(Class<?> clazz) {
        if (!clazz.isInterface()) {
            ToolingParameterProxy.throwParameterValidationError(clazz, "It must be an interface.");
        }
        HashMap setters = new HashMap();
        HashMap getters = new HashMap();
        for (Method method : clazz.getDeclaredMethods()) {
            String property;
            if (ToolingParameterProxy.isGetter(method)) {
                property = ToolingParameterProxy.getPropertyName(method.getName());
                if (getters.containsKey(property)) {
                    ToolingParameterProxy.throwParameterValidationError(clazz, String.format("More than one getter for property %s was found.", property));
                }
                getters.put(property, method.getReturnType());
                continue;
            }
            if (ToolingParameterProxy.isSetter(method)) {
                property = ToolingParameterProxy.getPropertyName(method.getName());
                if (setters.containsKey(property)) {
                    ToolingParameterProxy.throwParameterValidationError(clazz, String.format("More than one setter for property %s was found.", property));
                }
                setters.put(property, method.getParameterTypes()[0]);
                continue;
            }
            ToolingParameterProxy.throwParameterValidationError(clazz, String.format("Method %s is neither a setter nor a getter.", method.getName()));
        }
        if (setters.size() != getters.size()) {
            ToolingParameterProxy.throwParameterValidationError(clazz, "It contains a different number of getters and setters.");
        }
        for (String property : setters.keySet()) {
            if (!getters.containsKey(property)) {
                ToolingParameterProxy.throwParameterValidationError(clazz, String.format("A setter for property %s was found but no getter.", property));
                continue;
            }
            if (((Class)setters.get(property)).equals(getters.get(property))) continue;
            ToolingParameterProxy.throwParameterValidationError(clazz, String.format("Setter and getter for property %s have non corresponding types.", property));
        }
    }

    private static boolean isGetter(Method method) {
        String methodName = method.getName();
        return (ToolingParameterProxy.isPrefixable(methodName, "get") || ToolingParameterProxy.isPrefixable(methodName, "is")) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isSetter(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return ToolingParameterProxy.isPrefixable(method.getName(), "set") && parameterTypes.length == 1 && !parameterTypes[0].equals(Void.TYPE) && method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isPrefixable(String methodName, String prefix) {
        return methodName.startsWith(prefix) && methodName.length() > prefix.length() && Character.isUpperCase(methodName.charAt(prefix.length()));
    }

    private static String getPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            return ToolingParameterProxy.getPropertyName(methodName, "get");
        }
        if (methodName.startsWith("is")) {
            return ToolingParameterProxy.getPropertyName(methodName, "is");
        }
        if (methodName.startsWith("set")) {
            return ToolingParameterProxy.getPropertyName(methodName, "set");
        }
        return null;
    }

    private static String getPropertyName(String methodName, String prefix) {
        String property = methodName.replaceFirst(prefix, "");
        return Character.toLowerCase(property.charAt(0)) + property.substring(1);
    }

    private static void throwParameterValidationError(Class<?> clazz, String cause) {
        throw new IllegalArgumentException(String.format("%s is not a valid parameter type. %s", clazz.getName(), cause));
    }
}

