/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.tree;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.LightPsiParser;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lang.PsiParser;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;

public class ILightStubFileElementType<T extends PsiFileStub>
extends IStubFileElementType<T> {
    public ILightStubFileElementType(Language language) {
        super(language);
    }

    public ILightStubFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new LightStubBuilder();
    }

    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiElement psi = chameleon.getPsi();
        assert (psi != null) : "Bad chameleon: " + chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        PsiBuilder builder = factory.createBuilder(project, chameleon);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        assert (parserDefinition != null) : this;
        PsiParser parser = parserDefinition.createParser(project);
        if (parser instanceof LightPsiParser) {
            ((LightPsiParser)((Object)parser)).parseLight(this, builder);
        } else {
            parser.parse(this, builder);
        }
        return builder.getLightTree();
    }
}

