/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.jar.JarEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.JarLoader;
import org.jetbrains.kotlin.com.intellij.util.lang.JdkZipResourceFile;

final class SecureJarLoader
extends JarLoader {
    @Nullable
    private volatile ProtectionDomain protectionDomain;
    private final Object protectionDomainMonitor;

    SecureJarLoader(@NotNull Path file2, @NotNull ClassPath configuration) throws IOException {
        if (file2 == null) {
            SecureJarLoader.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            SecureJarLoader.$$$reportNull$$$0(1);
        }
        super(file2, configuration, new JdkZipResourceFile(file2, configuration.lockJars, true));
        this.protectionDomainMonitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProtectionDomain getProtectionDomain(@NotNull JarEntry entry, URL url) {
        ProtectionDomain result2;
        if (entry == null) {
            SecureJarLoader.$$$reportNull$$$0(2);
        }
        if ((result2 = this.protectionDomain) != null) {
            return result2;
        }
        Object object = this.protectionDomainMonitor;
        synchronized (object) {
            result2 = this.protectionDomain;
            if (result2 != null) {
                return result2;
            }
            CodeSource codeSource = new CodeSource(url, entry.getCodeSigners());
            this.protectionDomain = result2 = new ProtectionDomain(codeSource, new Permissions());
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/SecureJarLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getProtectionDomain";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

