/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.HardcodedIpCheckKt;

@Rule(key="S1313")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedIpCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "visitStringTemplateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class HardcodedIpCheck
extends AbstractCheck {
    @Override
    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @NotNull KotlinFileContext context) {
        block3: {
            String ipv4;
            String content2;
            block2: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(context, "context");
                if (expression2.hasInterpolation()) {
                    return;
                }
                content2 = this.asConstant(expression2);
                MatchResult matcher = HardcodedIpCheckKt.access$getIPV4_URL_REGEX$p().matchEntire(content2);
                if (matcher == null) break block2;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(matcher.getGroups(), "ipv4");
                Intrinsics.checkNotNull(matchGroup);
                String ip = matchGroup.getValue();
                if (!HardcodedIpCheckKt.access$isValidIPV4(ip) || HardcodedIpCheckKt.access$isIPV4Exception(ip)) break block3;
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)expression2, "Make sure using this hardcoded IP address is safe here.", null, null, 12, null);
                break block3;
            }
            MatchResult matchResult = (MatchResult)SequencesKt.firstOrNull(SequencesKt.mapNotNull(CollectionsKt.asSequence(HardcodedIpCheckKt.access$getIPV6_REGEX_LIST$p()), (Function1)new Function1<Regex, MatchResult>(content2){
                final /* synthetic */ String $content;
                {
                    this.$content = $content;
                    super(1);
                }

                @Nullable
                public final MatchResult invoke(@NotNull Regex pattern) {
                    Intrinsics.checkNotNullParameter(pattern, "pattern");
                    return pattern.matchEntire(this.$content);
                }
            }));
            if (matchResult == null) break block3;
            MatchResult match = matchResult;
            boolean bl = false;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "ipv6");
            Intrinsics.checkNotNull(matchGroup);
            String ipv6 = matchGroup.getValue();
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get(match.getGroups(), "ipv4");
            String string2 = ipv4 = matchGroup2 != null ? matchGroup2.getValue() : null;
            if (HardcodedIpCheckKt.access$isValidIPV6(ipv6, ipv4) && !HardcodedIpCheckKt.access$isIPV6Exception(ipv6)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)expression2, "Make sure using this hardcoded IP address is safe here.", null, null, 12, null);
            }
        }
    }
}

