/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.AbstractTooLongFunctionRule;

@Rule(key="S5612")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/TooLongLambdaCheck;", "Lorg/sonarsource/kotlin/checks/AbstractTooLongFunctionRule;", "()V", "elementName", "", "getElementName", "()Ljava/lang/String;", "max", "", "getMax", "()I", "setMax", "(I)V", "visitLambdaExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class TooLongLambdaCheck
extends AbstractTooLongFunctionRule {
    @RuleProperty(key="max", description="Maximum authorized lines of code in a lambda expression", defaultValue="20")
    private int max = 20;
    @NotNull
    private final String elementName;

    public TooLongLambdaCheck() {
        this.elementName = "lambda";
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setMax(int n) {
        this.max = n;
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KtFunctionLiteral ktFunctionLiteral = expression2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "getFunctionLiteral(...)");
        this.check(ktFunctionLiteral, kotlinFileContext);
    }
}

