/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.surefire;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonarsource.kotlin.surefire.KotlinSurefireParser;
import org.sonarsource.kotlin.surefire.api.SurefireUtils;

public class KotlinSurefireSensor
implements Sensor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KotlinSurefireSensor.class);
    private final KotlinSurefireParser kotlinSurefireParser;
    private final Configuration settings;
    private final PathResolver pathResolver;

    public KotlinSurefireSensor(KotlinSurefireParser kotlinSurefireParser, Configuration settings, PathResolver pathResolver) {
        this.kotlinSurefireParser = kotlinSurefireParser;
        this.settings = settings;
        this.pathResolver = pathResolver;
    }

    public void describe(SensorDescriptor descriptor2) {
        descriptor2.onlyOnLanguage("kotlin").name("KotlinSurefireSensor");
    }

    public void execute(SensorContext context) {
        List<File> dirs = SurefireUtils.getReportsDirectories(this.settings, context.fileSystem(), this.pathResolver);
        this.collect(context, dirs);
    }

    protected void collect(SensorContext context, List<File> reportsDirs) {
        LOGGER.info("parsing {}", (Object)reportsDirs);
        this.kotlinSurefireParser.collect(context, reportsDirs, this.settings.hasKey("sonar.junit.reportPaths"));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

