/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate.in;

import org.codehaus.staxmate.util.ArrayMaker;

public enum SMEvent {
    START_DOCUMENT(7),
    END_DOCUMENT(8),
    START_ELEMENT(1),
    END_ELEMENT(2),
    TEXT(4),
    CDATA(12),
    IGNORABLE_WS(6),
    COMMENT(5),
    PROCESSING_INSTR(3),
    DOCTYPE_DECL(11),
    ENTITY_DECL(15),
    ENTITY_REF(9),
    NOTATION_DECL(14),
    ATTRIBUTE(10),
    NAMESPACE_DECL(13),
    UNKNOWN(0);

    private final int mEventType;
    private static final int MASK_TEXTUAL_EVENT = 4176;
    private static final int MASK_HAS_TEXT = 65144;
    private static final int MASK_HAS_QNAME = 9222;
    private static final int MASK_HAS_LOCAL_NAME = 60942;

    private SMEvent(int evtType) {
        this.mEventType = evtType;
    }

    public int getEventCode() {
        return this.mEventType;
    }

    public boolean isElementEvent() {
        return this.mEventType == 1 || this.mEventType == 2;
    }

    public boolean isTextualEvent() {
        return (1 << this.mEventType & 0x1050) != 0;
    }

    public boolean hasText() {
        return (1 << this.mEventType & 0xFE78) != 0;
    }

    public boolean hasLocalName() {
        return (1 << this.mEventType & 0xEE0E) != 0;
    }

    public boolean hasQName() {
        return (1 << this.mEventType & 0x2406) != 0;
    }

    static SMEvent[] constructIdToEventMapping() {
        SMEvent[] evts;
        ArrayMaker arr = new ArrayMaker();
        for (SMEvent evt : evts = new SMEvent[]{ATTRIBUTE, CDATA, TEXT, COMMENT, DOCTYPE_DECL, END_DOCUMENT, END_ELEMENT, ENTITY_DECL, ENTITY_REF, NAMESPACE_DECL, NOTATION_DECL, PROCESSING_INSTR, IGNORABLE_WS, START_DOCUMENT, START_ELEMENT, UNKNOWN}) {
            arr.addEntry(evt.getEventCode(), (Object)evt);
        }
        return (SMEvent[])arr.toArray((Object[])new SMEvent[1]);
    }
}

