/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExternalAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public class JavaAnnotationImpl
extends JavaElementImpl<PsiAnnotation>
implements JavaAnnotation {
    public JavaAnnotationImpl(@NotNull JavaElementPsiSource<PsiAnnotation> psiAnnotation) {
        if (psiAnnotation == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(0);
        }
        super(psiAnnotation);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotationArgument> getArguments() {
        Collection<JavaAnnotationArgument> collection = JavaElementCollectionFromPsiArrayUtil.namedAnnotationArguments(((PsiAnnotation)this.getPsi()).getParameterList().getAttributes(), this.getSourceFactory());
        if (collection == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @Nullable
    public ClassId getClassId() {
        PsiClass resolved = this.resolvePsi();
        if (resolved != null) {
            return JavaAnnotationImpl.computeClassId(resolved);
        }
        String qualifiedName2 = ((PsiAnnotation)this.getPsi()).getQualifiedName();
        if (qualifiedName2 != null) {
            return ClassId.topLevel(new FqName(qualifiedName2));
        }
        return null;
    }

    @Override
    @Nullable
    public JavaClass resolve() {
        PsiClass resolved = this.resolvePsi();
        return resolved == null ? null : new JavaClassImpl(this.createPsiSource(resolved));
    }

    @Nullable
    private static ClassId computeClassId(@NotNull PsiClass psiClass) {
        PsiClass container;
        if (psiClass == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(2);
        }
        if ((container = psiClass.getContainingClass()) != null) {
            ClassId parentClassId = JavaAnnotationImpl.computeClassId(container);
            String name = psiClass.getName();
            return parentClassId == null || name == null ? null : parentClassId.createNestedClassId(Name.identifier(name));
        }
        String fqName2 = psiClass.getQualifiedName();
        return fqName2 == null ? null : ClassId.topLevel(new FqName(fqName2));
    }

    @Nullable
    private PsiClass resolvePsi() {
        PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)this.getPsi()).getNameReferenceElement();
        if (referenceElement == null) {
            return null;
        }
        PsiElement resolved = referenceElement.resolve();
        return resolved instanceof PsiClass ? (PsiClass)resolved : null;
    }

    @Override
    public boolean isIdeExternalAnnotation() {
        PsiAnnotation psi = (PsiAnnotation)this.getPsi();
        ExternalAnnotationsManager externalAnnotationManager = ExternalAnnotationsManager.getInstance(psi.getProject());
        return externalAnnotationManager.isExternalAnnotation(psi);
    }

    @Override
    public boolean isResolvedTo(@NotNull FqName fqName2) {
        PsiJavaCodeReferenceElement referenceElement;
        if (fqName2 == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(3);
        }
        if ((referenceElement = ((PsiAnnotation)this.getPsi()).getNameReferenceElement()) == null || !Objects.equals(referenceElement.getReferenceName(), fqName2.shortNameOrSpecial().asString())) {
            return false;
        }
        return ((PsiAnnotation)this.getPsi()).hasQualifiedName(fqName2.asString());
    }

    @Override
    public boolean isFreshlySupportedTypeUseAnnotation() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/structure/impl/JavaAnnotationImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/structure/impl/JavaAnnotationImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeClassId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

