/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.SimplifySizeExpressionCheckKt;

@Rule(key="S6529")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J2\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lorg/sonarsource/kotlin/checks/SimplifySizeExpressionCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "checkIsEmptyTest", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isIsEmpty", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "checkNullTest", "sizeTest", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "useIsEmpty", "sizeTestQualifier", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "checkNullTestOrReportSize", "doReportSize", "checkSizeTest", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitFunctionCall", "callExpression", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "matchedFun", "visitReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "sonar-kotlin-checks"})
public final class SimplifySizeExpressionCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public SimplifySizeExpressionCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{SimplifySizeExpressionCheckKt.access$getCountMatcher$p(), SimplifySizeExpressionCheckKt.access$isEmptyMatcher$p(), SimplifySizeExpressionCheckKt.access$isNotEmptyMatcher$p()};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (Intrinsics.areEqual(matchedFun, SimplifySizeExpressionCheckKt.access$getCountMatcher$p())) {
            this.checkSizeTest(callExpression, kotlinFileContext);
        } else {
            this.checkIsEmptyTest(callExpression, Intrinsics.areEqual(matchedFun, SimplifySizeExpressionCheckKt.access$isEmptyMatcher$p()), kotlinFileContext);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (expression2 instanceof KtNameReferenceExpression && (SimplifySizeExpressionCheckKt.access$getSizeFieldMatcher$p().matches((KtNameReferenceExpression)expression2, kotlinFileContext.getBindingContext()) || SimplifySizeExpressionCheckKt.access$getLengthFieldMatcher$p().matches((KtNameReferenceExpression)expression2, kotlinFileContext.getBindingContext()))) {
            this.checkSizeTest(expression2, kotlinFileContext);
        }
    }

    private final void checkSizeTest(KtExpression expression2, KotlinFileContext kotlinFileContext) {
        block13: {
            PsiElement psiElement;
            boolean isSizeEquals;
            KtBinaryExpression sizeTest;
            block12: {
                boolean bl;
                Integer operationTokenId;
                Integer n;
                PsiElement psiElement2 = expression2.getParent();
                Intrinsics.checkNotNullExpressionValue(psiElement2, "getParent(...)");
                PsiElement psiElement3 = this.skipParentParentheses(SimplifySizeExpressionCheckKt.access$expandOptionalQualifier(psiElement2));
                KtBinaryExpression ktBinaryExpression = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
                if (ktBinaryExpression == null) {
                    return;
                }
                sizeTest = ktBinaryExpression;
                Integer n2 = n = (operationTokenId = SimplifySizeExpressionCheckKt.access$getOperationTokenId(sizeTest));
                int n3 = 71;
                if (n2 != null && n2 == n3) {
                    bl = true;
                } else {
                    boolean bl2;
                    boolean bl3;
                    Integer n4 = n;
                    n3 = 72;
                    if (n4 != null && n4 == n3) {
                        bl3 = true;
                    } else {
                        Integer n5 = n;
                        n3 = 64;
                        bl3 = n5 != null && n5 == n3;
                    }
                    if (bl3) {
                        bl2 = true;
                    } else {
                        Integer n6 = n;
                        n3 = 63;
                        bl2 = n6 != null && n6 == n3;
                    }
                    if (bl2) {
                        bl = false;
                    } else {
                        return;
                    }
                }
                isSizeEquals = bl;
                BindingContext bindingContext2 = kotlinFileContext.getBindingContext();
                Integer n7 = operationTokenId;
                n3 = 63;
                if ((n7 == null || n7 != n3) && SimplifySizeExpressionCheckKt.access$isIntZeroLiteral(sizeTest.getRight(), bindingContext2)) break block12;
                Integer n8 = operationTokenId;
                n3 = 64;
                if (n8 != null && n8 == n3 || !SimplifySizeExpressionCheckKt.access$isIntZeroLiteral(sizeTest.getLeft(), bindingContext2)) break block13;
            }
            this.checkNullTestOrReportSize(sizeTest, isSizeEquals, true, (psiElement = expression2.getParent()) instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null, kotlinFileContext);
        }
    }

    private final void checkIsEmptyTest(KtCallExpression expression2, boolean isIsEmpty, KotlinFileContext kotlinFileContext) {
        boolean bl;
        PsiElement psiElement = expression2.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        PsiElement psiElement2 = this.skipParentParentheses(SimplifySizeExpressionCheckKt.access$expandOptionalQualifier(psiElement));
        if (psiElement2 == null) {
            return;
        }
        PsiElement isEmptyTest = psiElement2;
        if (isEmptyTest instanceof KtPrefixExpression) {
            Integer operationTokenId;
            Integer n = operationTokenId = SimplifySizeExpressionCheckKt.access$getOperationTokenId((KtExpression)isEmptyTest);
            int n2 = 60;
            bl = n != null && n == n2;
        } else {
            PsiElement endExclusive = isEmptyTest;
            isEmptyTest = expression2;
            while (!Intrinsics.areEqual(isEmptyTest.getParent(), endExclusive)) {
                Intrinsics.checkNotNullExpressionValue(isEmptyTest.getParent(), "getParent(...)");
            }
            bl = false;
        }
        boolean isNegated = bl;
        PsiElement psiElement3 = expression2.getParent();
        this.checkNullTestOrReportSize(isEmptyTest, isIsEmpty != isNegated, isNegated, psiElement3 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement3 : null, kotlinFileContext);
    }

    private final void checkNullTestOrReportSize(PsiElement sizeTest, boolean useIsEmpty, boolean doReportSize, KtDotQualifiedExpression sizeTestQualifier, KotlinFileContext kotlinFileContext) {
        if (this.checkNullTest(sizeTest, useIsEmpty, sizeTestQualifier, kotlinFileContext) || !doReportSize) {
            return;
        }
        String replaceFunction = useIsEmpty ? "isEmpty()" : "isNotEmpty()";
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, sizeTest, "Replace collection size check with \"" + replaceFunction + "\"", null, null, 12, null);
    }

    private final boolean checkNullTest(PsiElement sizeTest, boolean useIsEmpty, KtDotQualifiedExpression sizeTestQualifier, KotlinFileContext kotlinFileContext) {
        boolean bl;
        boolean bl2;
        KtDotQualifiedExpression ktDotQualifiedExpression = sizeTestQualifier;
        KtExpression ktExpression = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null;
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression sizeTestReceiver = ktNameReferenceExpression;
        Object object = this.skipParentParentheses(sizeTest.getParent());
        KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression connectorExpression = ktBinaryExpression;
        Object object2 = object = SimplifySizeExpressionCheckKt.access$getOperationTokenId(connectorExpression);
        int n = 74;
        if (object2 != null && (Integer)object2 == n) {
            bl2 = false;
        } else {
            Object object3 = object;
            n = 76;
            if (object3 != null && (Integer)object3 == n) {
                bl2 = true;
            } else {
                return false;
            }
        }
        boolean isOrConnector = bl2;
        if (isOrConnector != useIsEmpty) {
            return false;
        }
        KtExpression ktExpression2 = connectorExpression.getLeft();
        Object object4 = ktExpression2 != null ? this.skipParentheses(ktExpression2) : null;
        KtBinaryExpression ktBinaryExpression2 = object4 instanceof KtBinaryExpression ? (KtBinaryExpression)object4 : null;
        if (ktBinaryExpression2 == null) {
            return false;
        }
        KtBinaryExpression nullTest = ktBinaryExpression2;
        Object object5 = object4 = SimplifySizeExpressionCheckKt.access$getOperationTokenId(nullTest);
        int n2 = 71;
        if (object5 != null && (Integer)object5 == n2) {
            bl = true;
        } else {
            Object object6 = object4;
            n2 = 72;
            if (object6 != null && (Integer)object6 == n2) {
                bl = false;
            } else {
                return false;
            }
        }
        boolean isEqualsNull = bl;
        if (isEqualsNull != useIsEmpty) {
            return false;
        }
        KtNameReferenceExpression ktNameReferenceExpression2 = SimplifySizeExpressionCheckKt.access$getNullTestReference(nullTest);
        if (!Intrinsics.areEqual(ktNameReferenceExpression2 != null ? ktNameReferenceExpression2.getReferencedName() : null, sizeTestReceiver.getReferencedName())) {
            return false;
        }
        String replaceFunction = useIsEmpty ? "isNullOrEmpty()" : "!isNullOrEmpty()";
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)connectorExpression, "Replace null check and collection size check with \"" + replaceFunction + "\"", null, null, 12, null);
        return true;
    }
}

